package smart_gs.swingui.toolbar.action;

import java.io.File;

import javax.swing.filechooser.FileFilter;

import smart_gs.util.CanonicalPathString;

public class XmlFileFilter extends FileFilter{
	
	private String extension; 
	
	public XmlFileFilter() {
		super();
		this.extension = "xml";
	}
	
	public XmlFileFilter(String extension) {
		super();
		this.extension = extension;
	}

	public boolean accept(File pathname) {
		if((CanonicalPathString.get(pathname).endsWith("." + this.extension))) {
			return true;
		} else if(pathname.isDirectory()){
			return true;
		}
		return false;
	}

	@Override
	public String getDescription() {
		return extension;
	}
}