package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.drawing_tool.drawing_mode.LineSegEditorMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorSelectMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorTiltImagePanelLevelLineMode;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.util.GSLog;

public class LineSegEditorTiltImagePanelUpDownActionListener implements	ActionListener {
	LineSegEditor editor;
	double chageDegree;
	private GSLog log = GSLog.getInstance();
	
	public LineSegEditorTiltImagePanelUpDownActionListener(LineSegEditor editor,
			LineSegEditorTiltImagePanel lineSegEditorTiltImagePanel, double degree) {
		this.editor = editor;
		this.chageDegree = degree;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		LineSegEditorTiltImagePanel tiltpanel = editor.getTiltPanel();
		LineSegEditorMode mode = this.editor.getMode();
		double degree = tiltpanel.getDegree();
		if (Math.abs(degree+this.chageDegree)> 0.785d) {
			log .error("The level line cannot be tilted more than pi/4 radian (= 0.785 radian, = 45 degree) from the horizontal line.");
			return;
		}
		degree += this.chageDegree;
		if (mode instanceof LineSegEditorTiltImagePanelLevelLineMode) {
			((LineSegEditorTiltImagePanelLevelLineMode)mode).adjustLevelLine(this.chageDegree);
		}
		tiltpanel.setDegree(degree);
		tiltpanel.repaint();
	}

}
