package smart_gs.swingui.toolbar.action;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JOptionPane;

import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.toolbar.action.LineSegEditorChangeIndexesResultLinesMaker;

public class LineSegEditorChangeIndexesActionListener implements ActionListener {
	LineSegEditor editor;
	
	public LineSegEditorChangeIndexesActionListener(LineSegEditor editor) {
		this.editor = editor;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		editor.pushUndoStack();
		String input = JOptionPane.showInputDialog("Specify as 12>1 14-16>2 18>8:", "");
		if(input == null){
			return;
		}

		LineSegEditorChangeIndexesResultLinesMaker mkr = new LineSegEditorChangeIndexesResultLinesMaker(input,this.editor.getLinesForEdit());

		mkr.process();
		if (mkr.isCanceled()) return;
		this.editor.setLinesForEdit(mkr.getLines());
		this.editor.rewriteLineSegIndexes();
		this.editor.setLineSegEditorImageLabelCursor(new Cursor(Cursor.DEFAULT_CURSOR));
		this.editor.invalidate();
		this.editor.validate();
		this.editor.repaint();
	}
}
