package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import org.apache.commons.io.FileUtils;

import smart_gs.logical.LineSegment;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.util.DSCFileMaker;



public class LineSegDscInformationAction implements ActionListener {
	private LineSegEditor editor;
	private Spread spread;
	
	public LineSegDscInformationAction(LineSegEditor parent) {
		this.editor = parent;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		this.spread = this.editor.getSpread();
		String information;
		File imageFile = spread.getImageFile();
		File dscFile = spread.getDscFile();
		File lineSegXmlFile = spread.getLineSegXmlFile();
		File dscLineSegXmlFile = spread.getDscLineSegXmlFile();
		File lineSegSegfoFile = spread.getLineSegSegfoFile();
		File dscLineSegSegfoFile = spread.getDscLineSegSegfoFile();
		String imageFileInfo;
		String dscFileInfo;
		String lineSegFileInfo;
		String dscLineSegFileInfo;
		DateFormat df1 = DateFormat.getDateTimeInstance(DateFormat.LONG,DateFormat.LONG);
		
		String title = imageFile.getName() + "\n";
		if (imageFile == null || !imageFile.exists()){
			imageFileInfo = "Image File: none\n";
			}
		else {
			imageFileInfo = String.format("Image File: Size %s; Last modefied %s\n",
					FileUtils.byteCountToDisplaySize(imageFile.length()),
					df1.format(new Date(imageFile.lastModified())));
		}
		if (lineSegXmlFile == null || !lineSegXmlFile.exists()){
			lineSegFileInfo = "Line Segment Xml File: none\n";
		}
		else {
			lineSegFileInfo = String.format("Line Segment Xml File for Image File: Size %s; Last modefied %s\n",
					FileUtils.byteCountToDisplaySize(lineSegXmlFile.length()),
					df1.format(new Date(lineSegXmlFile.lastModified())));
		}
		if (lineSegSegfoFile == null || !lineSegSegfoFile.exists()){
			lineSegFileInfo += "Line Segment Segfo File: none\n";
		}
		else {
			lineSegFileInfo += String.format("Line Segment Segfo File for Image File: Size %s; Last modefied %s\n",
					FileUtils.byteCountToDisplaySize(lineSegSegfoFile.length()),
					df1.format(new Date(lineSegSegfoFile.lastModified())));
		}
		if (dscFile == null || !dscFile.exists()){
			dscFileInfo = "DSC File: none\n";
		}
		else {
			dscFileInfo = String.format("DSC File: Size %s; Last modefied %s\n",
					FileUtils.byteCountToDisplaySize(dscFile.length()),
					df1.format(new Date(dscFile.lastModified())));
		}
		if (dscLineSegXmlFile == null || !dscLineSegXmlFile.exists()){
			dscLineSegFileInfo = "Line Segment Xml File for DSC file: none\n";
		}
		else {
			dscLineSegFileInfo = String.format("Line Segment Xml File for DSC file: Size %s; Last modefied %s\n",
					FileUtils.byteCountToDisplaySize(dscLineSegXmlFile.length()),
					df1.format(new Date(dscLineSegXmlFile.lastModified())));
		}
		if (dscLineSegSegfoFile == null || !dscLineSegSegfoFile.exists()){
			dscLineSegFileInfo += "Line Segment Segfo File for DSC file: none\n";
		}
		else {
			dscLineSegFileInfo += String.format("Line Segment Segfo File for DSC file: Size %s; Last modefied %s\n",
					FileUtils.byteCountToDisplaySize(dscLineSegSegfoFile.length()),
					df1.format(new Date(dscLineSegSegfoFile.lastModified())));
		}
		
		JOptionPane.showMessageDialog(editor, title + imageFileInfo + lineSegFileInfo + dscFileInfo + dscLineSegFileInfo);
	}

}
