/* $Id: SearchToolBar.java 1064 2016-01-24 16:02:47Z shayashi $ */
package smart_gs.swingui.toolbar;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.swingui.toolbar.action.SearchActionListener;
import smart_gs.swingui.toolbar.action.Text2ImageActionListener;
import smart_gs.transcription_tool.OcrDialog;
@SuppressWarnings("serial")
public class SearchToolBar extends JToolBar{
	
	public SearchToolBar(GSEditorFrame parent){
		
		ImageIcon searchIconPrinted = new ImageIcon(GSConstants.ICON_PATH+"search2.png");
		ImageIcon smallIconPrinted = 
			new ImageIcon(searchIconPrinted.getImage()
					.getScaledInstance((int) (searchIconPrinted.getIconWidth() * 0.8), -1,
							Image.SCALE_SMOOTH));

		JButton searchPrinted = new JButton(smallIconPrinted);
		searchPrinted.addActionListener(new SearchActionListener(parent,0));
		searchPrinted.setToolTipText("Open Search Dialog");
		this.add(searchPrinted);
		
		ImageIcon searchIconHandwritten = new ImageIcon(GSConstants.ICON_PATH+"searchHandwritten.png");
		ImageIcon smallIconHandwritten = 
			new ImageIcon(searchIconHandwritten.getImage()
					.getScaledInstance((int) (searchIconHandwritten.getIconWidth() * 0.8), -1,
							Image.SCALE_SMOOTH));

		JButton searchHandwritten = new JButton(smallIconHandwritten);
		searchHandwritten.addActionListener(new SearchActionListener(parent,1));
		searchHandwritten.setToolTipText("Open Search Dialog");
		this.add(searchHandwritten);
		
		ImageIcon ocrIcon = new ImageIcon(GSConstants.ICON_PATH+"ocr.png");
		ImageIcon ocrSmallIcon = 
			new ImageIcon(ocrIcon.getImage()
					.getScaledInstance((int) (ocrIcon.getIconWidth() * 0.75), -1,
							Image.SCALE_SMOOTH));

		JButton ocr = new JButton(ocrSmallIcon);
		ocr.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				new OcrDialog();
			}
		});
		ocr.setToolTipText("Open OCR Dialog");
		this.add(ocr);		
		
		JButton text2Image = new JButton("Text-Image");
		text2Image.addActionListener(new Text2ImageActionListener());
//		this.add(text2Image);
	}
}
