/* $Id: ToolBarPanel.java 1025 2015-10-25 12:35:25Z shayashi $ */
package smart_gs.swingui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import smart_gs.GSConstants;
import smart_gs.swingui.toolbar.DefaultToolBar;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import smart_gs.swingui.toolbar.RbRwToolBar;
import smart_gs.swingui.toolbar.UtilityToolBar;
import smart_gs.swingui.toolbar.SearchToolBar;
import smart_gs.swingui.toolbar.action.ShowLinesActionListener;
import smart_gs.util.GSLog;
import sml_editor.logical.LineDirection;
import sml_editor.swingui.EditorTextPane;
@SuppressWarnings("serial")
public class ToolBarPanel extends JPanel{
	
	private GSEditorToolBar editorToolBar;
	private MoveTreeToolBar moveTreeToolBar;
	private HistoryToolBar historyToolBar;
	private ImageToolBar imageToolBar;
	private RbRwToolBar rbrwToolBar;
	private static JLabel horizontalLineTextIcon = null;
	private static JLabel verticalLineTextIcon = null;
	private static JLabel undefinedLineTextIcon = null;
	private JLabel lineTextIcon = null;
	private UtilityToolBar utilityToolBar;
	private AbstractGSWindow parent;
	private JPanel lineDirectionPanel;



	public ToolBarPanel(AbstractGSWindow parent, boolean isInWorkspaceWindow){
		//		super(new GridLayout(1,1));
		//		super(new BorderLayout());
		this.setLayout(new FlowLayout(FlowLayout.LEFT));
		
		this.parent = parent;
		
		if (horizontalLineTextIcon == null) {
			try {
				horizontalLineTextIcon = new JLabel( new ImageIcon(ImageIO.read(new File("./icons/horizontal.png"))));
			} catch (IOException e) {
				GSLog.getInstance().warn("Failed to read horizontal.png");
			}
		}
		
		if (verticalLineTextIcon == null) {
			try {
				verticalLineTextIcon = new JLabel( new ImageIcon(ImageIO.read(new File("./icons/vertical.png"))));
			} catch (IOException e) {
				GSLog.getInstance().warn("Failed to read vertical.png");
			}
		}
		
		if (undefinedLineTextIcon == null) {
			try {
				undefinedLineTextIcon = new JLabel( new ImageIcon(ImageIO.read(new File("./icons/undefined.png"))));
			} catch (IOException e) {
				GSLog.getInstance().warn("Failed to read undefined.png");
			}
		}
		
		
		this.lineTextIcon = undefinedLineTextIcon;
		
		this.lineDirectionPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		this.lineDirectionPanel.add(this.lineTextIcon);
		this.lineDirectionPanel.validate();
		
		JPanel panel1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		panel1.add(this.lineDirectionPanel);
		if (isInWorkspaceWindow) panel1.add(new DefaultToolBar());
		this.imageToolBar = new ImageToolBar(parent);
		panel1.add(imageToolBar);
		this.rbrwToolBar = new RbRwToolBar(parent);
		panel1.add(rbrwToolBar);
		panel1.add(new SearchToolBar(parent));
		panel1.validate();
		this.add(panel1);
		this.validate();

		this.utilityToolBar = new UtilityToolBar(parent,isInWorkspaceWindow);
		panel1.add(this.utilityToolBar);
		
		if (isInWorkspaceWindow) {
			moveTreeToolBar = new MoveTreeToolBar(parent);
			panel1.add(moveTreeToolBar);
			historyToolBar = new HistoryToolBar(parent);
			panel1.add(historyToolBar);
		}
		
		panel1.validate();

		this.add(panel1);
		this.validate();
	}
	
	public void setLineDirectionIcon(LineDirection direction) {
		if (lineTextIcon != null) this.lineDirectionPanel.remove(lineTextIcon);
		if (direction == LineDirection.HORIZONTAL) {
			lineTextIcon = horizontalLineTextIcon;
		}
		
		if (direction.equals(LineDirection.VERTICAL)) {
			lineTextIcon = verticalLineTextIcon;

		} 
		
		if (direction.equals(LineDirection.UNDEFINED)){
			lineTextIcon = undefinedLineTextIcon;
		}
		
	    this.lineDirectionPanel.add(lineTextIcon);
	    this.validate();
	    this.parent.validate();
	}


	public GSEditorToolBar getGSEditorToolBar(){
		return editorToolBar;
	}
	public HistoryToolBar getHistoryToolBar(){
		return historyToolBar;
	}
	public MoveTreeToolBar getMoveTreeToolBar(){
		return moveTreeToolBar;
	}
	public ImageToolBar getImageToolBar() {
		return imageToolBar;
	}
	
	public UtilityToolBar getUtilityToolBar() {
		return utilityToolBar;
	}
}
