/* $Id: ConnectionView.java 1085 2016-04-03 03:01:02Z minao $ */
package smart_gs.reasoning_web.swingui.view;


import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import reasoning_web.logical.Connection;
import smart_gs.reasoning_web.logical.GSConnection;


/**
 * @author kazuaki kobayashi
 *
 */ 
public class ConnectionView extends PathView {
	
	private GSConnection connection; 
	private View sourceView;
	private View targetView;
	
	public ConnectionView(GSConnection connection) {
		this.connection = connection;
		
		this.sourceView = this.connection.getSourcePointer().getView();
		this.targetView = this.connection.getTargetPointer().getView();
		//2007/10/22 kazuhiro kobayashi
//		this.targetView.moveBy(new Point(-100,-100));
	}
	
	public View getSourceView(){
		return this.sourceView;
	}
	public View getTargetView(){
		return this.targetView;
	}
	public void drawShape(Graphics2D g) {
		g.setStroke(new BasicStroke());
		Color oldColor = g.getColor();
		this.sourceView.drawShape(g);
		this.targetView.drawShape(g);
		Rectangle2D srcbd = ((ResourcePointerView)sourceView).getShape().getBounds();
		Rectangle2D destbd = ((ResourcePointerView)targetView).getShape().getBounds();
		
		Point2D srcCenter = new Point2D.Double(srcbd.getCenterX(),srcbd.getCenterY());
		Point2D destCenter = new Point2D.Double(destbd.getCenterX(),destbd.getCenterY());
		Point2D middlePoint = new Point2D.Double((srcCenter.getX() + destCenter.getX()) / 2,(srcCenter.getY() + destCenter.getY()) / 2);
		
		Point2D srcPoint,destPoint;
		if(!(srcbd.intersects(destbd))){
			if((srcbd.outcode(middlePoint) & Rectangle2D.OUT_LEFT) != 0){
				srcPoint = new Point2D.Double(srcbd.getX(),srcbd.getY() + srcbd.getHeight() / 2 + srcbd.getHeight() / 20 * (0 % 2 == 1 ? 1 : -1) * (1));
			}
			else if((srcbd.outcode(middlePoint) & Rectangle2D.OUT_RIGHT) != 0){
				srcPoint = new Point2D.Double(srcbd.getX() + srcbd.getWidth(),srcbd.getY() + srcbd.getHeight() / 2 + srcbd.getHeight() / 20 * (0 % 2 == 1 ? 1 : -1) * (1));
			}
			else if((srcbd.outcode(middlePoint) & Rectangle2D.OUT_TOP) != 0){
				srcPoint = new Point2D.Double(srcbd.getX() + srcbd.getWidth() / 2 + srcbd.getWidth() / 20 * (0 % 2 == 1 ? 1 : -1) * ( 1),srcbd.getY());
			}
			else{
				srcPoint = new Point2D.Double(srcbd.getX() + srcbd.getHeight() / 2 + srcbd.getWidth() / 20 * (0 % 2 == 1 ? 1 : -1) * ( 1),srcbd.getY() + srcbd.getHeight());
			}
			
			if((destbd.outcode(middlePoint) & Rectangle2D.OUT_LEFT) != 0){
				destPoint = new Point2D.Double(destbd.getX(),destbd.getY() + destbd.getHeight() / 2 + destbd.getHeight() / 20 * (0 % 2 == 1 ? 1 : -1) * (1));
			}
			else if((destbd.outcode(middlePoint) & Rectangle2D.OUT_RIGHT) != 0){
				destPoint = new Point2D.Double(destbd.getX() + destbd.getWidth(),destbd.getY() + destbd.getHeight() / 2 + destbd.getHeight() / 20 * (1 % 2 == 1 ? 1 : -1) * (1));
			}
			else if((destbd.outcode(middlePoint) & Rectangle2D.OUT_TOP) != 0){
				destPoint = new Point2D.Double(destbd.getX() + destbd.getWidth() / 2 + destbd.getWidth() / 20 * (0 % 2 == 1 ? 1 : -1) * (1),destbd.getY());
			}
			else{
				destPoint = new Point2D.Double(destbd.getX() + destbd.getHeight() / 2 + destbd.getWidth() / 20 * (0 % 2 == 1 ? 1 : -1) * (1),destbd.getY() + destbd.getHeight());
			}
			
			line = new Line2D.Double(srcPoint,destPoint);
			
			if(this.isSelected){
				g.setColor(Color.RED);
				g.setStroke(new BasicStroke(5));
			}else{
				g.setColor(Color.BLACK);
				g.setStroke(new BasicStroke());
			}
			//2007/10/30 kazuhiro kobayashi
//			g.setColor(oldColor);
			this.drawArrow((int)srcPoint.getX(),(int)srcPoint.getY(),(int)destPoint.getX(),(int)destPoint.getY(),10,g);
			g.setColor(oldColor);
		}
		else
			line = null;
	}
	private void drawArrow(int x0,int y0,int x1,int y1,int l,Graphics2D g){
		double theta;
		int x,y;
		double dt = Math.PI / 6.0;
		theta = Math.atan2((double)(y1-y0),(double)(x1-x0));
		g.drawLine(x0,y0,x1,y1);
		x = x1-(int)(l*Math.cos(theta-dt));
		y = y1-(int)(l*Math.sin(theta-dt));
		g.drawLine(x1,y1,x,y);
		x = x1-(int)(l*Math.cos(theta+dt));
		y = y1-(int)(l*Math.sin(theta+dt));
		g.drawLine(x1,y1,x,y);
	}
	
	public String toString() {
		return "connection";
	}
	public Connection getConnection() {
		return connection;
	}
	public Rectangle2D getRectangle(){
		return null;
	}
	public void setRectangle(double x, double y, double w, double h){	
	}
	public void setRectangle(double x, double y){
	}
}
