/* $Id: RWGlobalViewMouseListener.java 1085 2016-04-03 03:01:02Z minao $ */
/*
 * 作成日: 2006/06/02
 *
 */
package smart_gs.reasoning_web.swingui.action;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ResourcePointer;
import smart_gs.debugprint.Debugprint;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.RWGlobalViewPanel;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.reasoning_web.swingui.view.ResourcePointerView;
import smart_gs.reasoning_web.swingui.view.View;
import smart_gs.swingui.WorkspaceWindow;

/**
 * @author kazuaki kobayashi
 * 
 * 
 */
// 右のパネルでのマウスの操作
public class RWGlobalViewMouseListener implements MouseListener,
		MouseMotionListener {

	private Point2D start = null;
	private Point2D end = null;

	private GS_RWElement selectedElement;
	private Connection selectedConnection;
	private View selectedView;

	//2007/11/19 kazuhiro kobayashi
	private final Rectangle rect = new Rectangle();

	public void mouseClicked(MouseEvent e) {
		this.start = e.getPoint();

		GS_RWElement element = (GS_RWElement) RWGlobalViewPanel.getInstance()
				.getElement(e.getPoint());
		if (e.getButton() == MouseEvent.BUTTON3 ||
				/* alternative for right button click */
				(e.getButton() == MouseEvent.BUTTON1 & WorkspaceWindow.getInstance().isAlt())) {
			ResourcePointer pointer = RWGlobalViewPanel.getInstance()
					.getResourcePointer(e.getPoint());
			if (pointer != null) {
				PointerRightClickMenu pmenu = new PointerRightClickMenu(pointer);
				pmenu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
			} else {
				Connection connection = RWGlobalViewPanel.getInstance()
						.getConnection(e.getPoint());
				if (connection != null) {
					this.setSelectedConnection(connection);
					ConnectionRightClickMenu cmenu = new ConnectionRightClickMenu(
							(GS_RWElement) connection);
					cmenu
							.show(e.getComponent(), e.getPoint().x, e
									.getPoint().y);
				}
			}
		}

		if (element == null) {
			this.selectedElement = null;
			return;
		}

		this.selectedElement = element;
		if (e.getClickCount() == 2) {
			element.show();
			return;
		}

//		GS_RWRepository.getInstance();

	}

	public GS_RWElement getSelectedElement() {
		return this.selectedElement;
	}

	// 2007/10/30 kazuhiro kobayashi
	public void setSelectedElement(GS_RWElement element) {
		this.selectedElement = element;
	}
	

	public void mouseEntered(MouseEvent e) {

	}

	public void mouseExited(MouseEvent e) {

	}

	public void mousePressed(MouseEvent e) {
		this.start = e.getPoint();

		if (this.selectedView != null) {
			if (!this.selectedView.contains(e.getPoint())) {
				this.selectedView.setIsSelected(false);
				this.selectedView = null;
				this.selectedElement = null;
			}
		}

		View view = RWGlobalViewPanel.getInstance().getView(e.getPoint());

		this.selectedElement = (GS_RWElement) RWGlobalViewPanel.getInstance()
				.getElement(e.getPoint());

		if (view == null) {
			return;
		}
		
		view.setIsSelected(true);
		this.selectedView = view;

		ReasoningWebFrame.getInstance().getElementsPanel().setElement(this.selectedElement);
		RWGlobalViewPanel.getInstance().repaint();
	}

	public void mouseReleased(MouseEvent e) {
		View tmp_view = this.selectedView;
		if (tmp_view instanceof ResourcePointerView) ((ResourcePointerView)tmp_view).adjustLocation();
		this.start = null;
		this.end = null;

		RWGlobalViewPanel.getInstance().setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
		RWGlobalViewPanel.getInstance().repaint();
	}

	public void mouseDragged(MouseEvent e) {
		this.end = e.getPoint();
		
		if (this.selectedView == null) {

			//2007/11/19 kazuhiro kobayashi
			RWGlobalViewPanel.getInstance().setCursor(
					new Cursor(Cursor.HAND_CURSOR));
			Rectangle r = RWGlobalViewPanel.getInstance().getVisibleRect();
			this.rect.setRect(r.x - this.end.getX() + this.start.getX(), r.y
					- this.end.getY() + this.start.getY(), r.getWidth(), r
					.getHeight());
			RWGlobalViewPanel.getInstance().scrollRectToVisible(this.rect);
			//
			
			return;
		}

		// 2007/11/1 kazhiro kobayashi
		if (this.end.getX() <= 0) {
			this.end.setLocation(5, this.end.getY());
		}
		if (this.end.getY() <= 0) {
			this.end.setLocation(this.end.getX(), 5);
		}
		Point2D point = new Point2D.Double(end.getX() - start.getX(), end
				.getY()
				- start.getY());
		this.selectedView.moveBy(point);
		this.start = this.end;
		RWGlobalViewPanel.getInstance().repaint();

		// 2007/11/1 kazuhiro koabayshi
		RWGlobalViewPanel.getInstance().setGlobalViewPanelSize(this.end);
	}

	public void mouseMoved(MouseEvent e) {

	}

	public Connection getSelectedConnection() {
		return selectedConnection;
	}

	public void setSelectedConnection(Connection selectedConnection) {
		this.selectedConnection = selectedConnection;
	}

}
