package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TimeZone;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.logical.FirstIDAT;
import smart_gs.logical.GSResource;
import smart_gs.logical.IDAT;
import smart_gs.logical.Region;
import smart_gs.logical.SecondIDAT;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.logical.URIObject;
import smart_gs.logical.UsersNote;
import smart_gs.logical.ZombieGSResourceForRestoring;
import smart_gs.menu.action.ResourceListSelectionFrame;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.util.InConstruction;

@SuppressWarnings("serial")
public class ResourceBasketPanel extends JPanel {

	private static final int BOX_HEIGHT = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;

	public ResourceBasketPanel(List<GSResource> resources,
			ResourceListSelectionFrame parent) {
		super();
		this.setLayout(new GridLayout(resources.size(), 1));

		Enumeration<GSResource> enume = Collections.enumeration(resources);
		
		while (enume.hasMoreElements()) {
			GS_RWElement element = (GS_RWElement)enume.nextElement();

			JSplitPane splitPane = new JSplitPane();
			splitPane.setBorder(new TitledBorder(element.getURI()));
	
			int width = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;
			int height = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;

			splitPane.setDividerLocation(width);
			
			try {
				JPanel elementViewPanel;
				if (element instanceof Region) {
					Region region = (Region)element;
					if (region.isZombie()) {
						elementViewPanel = ZombiePanel.getZombieElementViewPanelForLocalView(element.getURI());
					} else {
						elementViewPanel = ((Region)element).createElementViewPanelForLocalView();
					}
				} else if (element instanceof TextSegment) {
					TextSegment segment = (TextSegment)element;
					elementViewPanel = segment.createElementViewPanelForLocalView();
					if (elementViewPanel == null) {
						elementViewPanel = ZombiePanel.getZombieElementViewPanelForLocalView(element.getURI());
					}
				} else if (element instanceof ZombieGSResourceForRestoring) {
					ZombieGSResourceForRestoring zombie = (ZombieGSResourceForRestoring)element;
					elementViewPanel = zombie.createElementViewPanelForLocalView();
				} else {
					elementViewPanel = element.createElementViewPanel(width,height);
				}
				splitPane.setLeftComponent(elementViewPanel);
				
				
			} catch (NoWayToShowException e) {
				e.printStackTrace();
			}

			try {
				JPanel panel = new JPanel();
				panel.setLayout(new BorderLayout());
				panel.setPreferredSize(new Dimension((int)(BOX_HEIGHT*1.5),BOX_HEIGHT));
								
				String info = getInfo(element);
				JLabel label = new JLabel(info);
				JPanel panelToDisplayInformation = new JPanel();
				panelToDisplayInformation.add(label,BorderLayout.NORTH);
				splitPane.setRightComponent(panelToDisplayInformation);
				JButton deleteButton = new JButton("Delete");
				deleteButton.addActionListener(new DeleteResourceBasketItemActionListener(parent, element));
				panelToDisplayInformation.add(deleteButton, BorderLayout.SOUTH);


			} catch (Exception e) {
				e.printStackTrace();
			}
			this.add(splitPane);
		}
	}
	
	private static String getInfo(GS_RWElement element) {
		String uri = element.getURI();
		String[] token = (uri.substring(8)).split("/");
		TimeZone timeZone = TimeZone.getDefault();

		String toPrint = "";
		
		if (element instanceof Region) {
			String kind = ((Region)element).getTypeStringForDisplay();
			String userName = token[1];
			String creationTime = URIObject.localizeDate(timeZone, token[2]) 
									+ " ("+ timeZone.getID() +")";
			String locationKind = "Image";
			String locationName = token[4];
			String locationPath = ((Region)element).getSpread().getFolderPath();
			locationPath = "/root/" + locationPath + locationName;
			toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>Spread Name: %s<br>Path: %s<br></html>",
					kind,userName,creationTime,locationKind,locationName,locationPath);
		} else if (element instanceof TextSegment) {	
			String kind = "Text Segment";
			String userName = token[1];
			String creationTime = URIObject.localizeDate(timeZone, token[2]) 
									+ " ("+ timeZone.getID() +")";
			String locationKind = token[3];
			if (locationKind.equals("^usersNote")) {
				locationKind = "Users' Note";
			} else if (locationKind.equals("^firstIdat")) {
				locationKind = "first IDAT";
			} else if (locationKind.equals("^secondIdat")) {
				locationKind = "second IDAT";
			} else if (locationKind.equals("^thirdIdat")) {
				locationKind = "third IDAT";
			}


			if (locationKind.equals("Users' Note")) {
				String noteName = token[4];
				
				UsersNote note = (UsersNote)((TextSegment)element).getDocument();
				String notePath = "/root/" + note.getFolderPath() + noteName;
				toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>Note Name: %s<br>Path: %s<br></html>",
						kind,userName,creationTime,locationKind,noteName,notePath);
			} else {
				//IDAT case
				String spreadName;
				String idatName;
				spreadName = token[7];
				TextSegment seg = (TextSegment)element;
				IDAT idat = (IDAT)seg.getDocument();
				Spread spread = idat.getSpread();
				if (idat instanceof FirstIDAT) {
					idatName = spread.getFirstIDATName();
				} else if (idat instanceof SecondIDAT) {
					idatName = spread.getSecondIDATName();
				} else {
					idatName = spread.getThirdIDATName();
				}
				String spreadPath = spread.getFolderPath();
				spreadPath = "/root/" + spreadPath + spreadName;
				toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>IDAT Name: %s<br>Spread Name: %s<br>Spread Path: %s<br></html>",
						kind,userName,creationTime,locationKind,idatName,spreadName,spreadPath);
			}
		} else {
			// HERE HERE 2016.02.28
//			InConstruction.message();
			toPrint = "";
		}
		return toPrint;
	}
	
	class DeleteResourceBasketItemActionListener implements ActionListener {
	
		private ResourceListSelectionFrame parent;
		private GS_RWElement element;

		public DeleteResourceBasketItemActionListener(ResourceListSelectionFrame parent, 
			GS_RWElement element) {
			this.parent = parent;
			this.element = element;
		}

		@Override
		public void actionPerformed(ActionEvent arg0) {
			parent.deleteElement(element);
		}
		
	}
	
}
