/* $Id: RWElementsPanel.java 1109 2016-05-19 00:05:03Z minao $ */
package smart_gs.reasoning_web.swingui;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.debugprint.Debugprint;
import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.logical.GSResource;
import smart_gs.logical.URICreator;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.view.View;
import smart_gs.util.GSLog;

@SuppressWarnings("serial")
public class RWElementsPanel extends JPanel implements Observer, ListSelectionListener {
	
	private JList list;
	private List<Boolean> visibilityFlags;
	private MarkupTable markupTable;
	private ConnectionTable connectionTable;
	private JPanel markupScrollPane = new JPanel();
	private JPanel connectionPanel = new JPanel();
	private boolean displayList = false;
	private GSResource selectedElement = null;
	private GSConnection selectedConnection = null;
	
	public RWElementsPanel(){
		this.setLayout(new BorderLayout());
		
		this.list = new JList();
		List<GS_RWElement> elements = GS_RWRepository.getInstance().getAllElements_for_RWMainPanel();
		
		if (displayList) {
			this.list.setListData(elements.toArray());
			this.list.setCellRenderer(new RWElementPanelJListCellRenderer());
			this.list.addListSelectionListener(this);
			this.list.addMouseListener(mouseListener);
			this.add(this.list,BorderLayout.CENTER);
		} else {
		
			MarkupTableModel markupTableModel = 
					new MarkupTableModel();
			this.markupTable = new MarkupTable(markupTableModel);
			ConnectionTableModel connectionTableModel =
					new ConnectionTableModel();
			this.connectionTable = new ConnectionTable(connectionTableModel);
			this.connectionTable.setMarkupTable(markupTable);
			this.markupTable.setConnectionTable(connectionTable);
			
			JLabel markupLabel = new JLabel("Markups");
			markupLabel.setBorder(new LineBorder(Color.BLACK));
			JScrollPane markupScrollPane = new JScrollPane();
			markupScrollPane.setViewportView(markupTable);
			JPanel markupPanel = new JPanel(new BorderLayout());
			markupPanel.add(markupLabel, BorderLayout.NORTH);
			markupPanel.add(markupScrollPane, BorderLayout.CENTER);
			
			JLabel connectionLabel = new JLabel("Connections");
			connectionLabel.setBorder(new LineBorder(Color.BLACK));
			JScrollPane connectionScrollPane = new JScrollPane();
			connectionScrollPane.setViewportView(connectionTable);
			JPanel connectionPanel = new JPanel(new BorderLayout());
			connectionPanel.add(connectionLabel, BorderLayout.NORTH);
			connectionPanel.add(connectionScrollPane, BorderLayout.CENTER);
			
			JSplitPane spp = new JSplitPane();
			spp.setOrientation(JSplitPane.VERTICAL_SPLIT);
			spp.setDividerLocation((ReasoningWebFrame.HEIGHT -150)/2);
			spp.setLeftComponent(markupPanel);
			spp.setRightComponent(connectionPanel);
			this.add(spp, BorderLayout.CENTER);
		}
	}
	
	 MouseListener mouseListener = new MouseAdapter() {
	     public void mousePressed(MouseEvent e) {
	         if ((e.getButton() == MouseEvent.BUTTON3) || (e.getButton() == MouseEvent.BUTTON1 & e.isAltDown())) {
	             int index = list.locationToIndex(e.getPoint());
	             GSLog.getInstance().warn("Double clicked on Item " + index);
	          }
	     }
	 };	
	
	public void reload(){
		List<GS_RWElement> elements = GS_RWRepository.getInstance().getAllElements_for_RWMainPanel();
		if (displayList) {
			this.list.removeAll();
			this.list.setListData(elements.toArray());
			this.validate();
		} else {
			this.markupTable.getResourceTableModel().removeAllRows();
			this.connectionTable.getResourceTableModel().removeAllRows();
			ArrayList<GSResource> markups = new ArrayList<GSResource>();
			ArrayList<GSConnection> connections = new ArrayList<GSConnection>();
			for (int i = 0; i < elements.size(); i++) {
				if (elements.get(i).getTypeString().equals(URICreator.CONNECTION)) {
					connections.add((GSConnection) elements.get(i));
				} else {
					markups.add((GSResource) elements.get(i));
				}
			}
			this.markupTable.getResourceTableModel().setMarkups(markups);
			this.markupTable.setSelectedElement(this.selectedElement);
			this.connectionTable.getResourceTableModel().setConnections(connections);
			this.connectionTable.setSelectedConnection(this.selectedConnection);
		}

	}

	public void update() {
		this.reload();
	}

	public void valueChanged(ListSelectionEvent e) {
		RWElement element = (RWElement)this.list.getSelectedValue();
		if(element == null){
			return;
		}
		View.clearSelection();
		if(GS_RWRepository.getInstance().getResourcePointer((GS_RWElement)element) != null){
			GS_RWRepository.getInstance().getResourcePointer((GS_RWElement)element).getView().setIsSelected(true);
		}
		ReasoningWebFrame.getInstance().repaint();
	}

	public void setElement(RWElement selectedElement) {
		if (displayList) {
			this.list.setSelectedValue(selectedElement,true);
			ReasoningWebFrame.getInstance().repaint();
		} else {
			if (selectedElement == null) {
				this.connectionTable.clearSelection();
				this.markupTable.clearSelection();
				return;
			}
			int index = -1;
			if (selectedElement.getTypeString() == URICreator.CONNECTION) {
								ArrayList<GSConnection> list = this.connectionTable.getResourceTableModel().getConnections();
				for (int i = 0; i < list.size(); i++) {
					if (list.get(i) == (GSConnection)selectedElement) {
						index = i;
						break;
					}
				}
				if (index < 0) return;
				this.connectionTable.setRowSelectionInterval(index, index);
			} else {
				ArrayList<GSResource> markups = this.markupTable.getResourceTableModel().getMarkups();
				for (int i = 0; i < markups.size(); i++) {
					if (markups.get(i) == (GSResource)selectedElement) {
						index = i;
						break;
					}
				}
				if (index < 0) return;
				this.markupTable.setRowSelectionInterval(index, index);
			}
		}
	}
	
	public int getIndexOf(RWElement element) {
		ArrayList<GSResource> markups = this.markupTable.getResourceTableModel().getMarkups();
		ArrayList<GSConnection> connections = this.connectionTable.getResourceTableModel().getConnections();
		if (markups != null) {
			for (int i = 0; i < markups.size(); i++) {
				if (markups.get(i) == (GSResource)element) {
					return i;
				}
			}
		} else if (connections != null) {
			for (int i = 0; i < connections.size(); i++) {
				if (connections.get(i) == (GSConnection)element) {
					return i;
				}
			}
		}
		return -1;
	}

	public ResourceTable getMarkupTable() {
		return this.markupTable;
	}

	public ResourceTable getConnectionTable() {
		return this.connectionTable;
	}
	
}
