/* $Id: DesktopPanel.java 428 2011-10-17 00:45:55Z minao $ */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.logical.GSResource;
import smart_gs.reasoning_web.RootFolder;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.desktop.swingui.FolderPanel;
import smart_gs.reasoning_web.desktop.swingui.ShortCutListPanel;

@SuppressWarnings("serial")
public class DesktopPanel extends JPanel{
	
	private DeskTopFolder rootFolder;
	private DeskTopFolder currentFolder;
	private FolderPanel mainPanel;	
	private JScrollPane scrollPane;
	private JToolBar toolBar;
	private ShortCutListPanel shortCutListPanel;
	/*
	 * mainPanelがFolderPanel classのものとJScrollPanel classの二つある
	 */
	public DesktopPanel(){
		this.scrollPane = new JScrollPane();
		this.toolBar = new DeskTopToolbar();
		this.rootFolder = RootFolder.getInstance();
		this.currentFolder = this.rootFolder;
		this.mainPanel = new FolderPanel(this.rootFolder);
		this.scrollPane.setViewportView(this.mainPanel);		
		this.setLayout(new BorderLayout());
		

		this.shortCutListPanel = new ShortCutListPanel(this.currentFolder);
		
		JScrollPane leftPanel = new JScrollPane(this.shortCutListPanel);
		JSplitPane mainPanel = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,leftPanel,this.scrollPane);
		mainPanel.setDividerLocation(300);
		this.add(mainPanel,BorderLayout.CENTER);
	}
	
	public DeskTopFolder getCurrentFolder() {	
		return this.currentFolder;
	}

	public void setMainPanel(FolderPanel panel) {
		this.scrollPane.setViewportView(panel);
		this.mainPanel = panel;
		this.currentFolder = panel.getFolder();
		//this.updateAll();
		//2007.11.24 Tsukushi Shimizu
		this.updateAll(currentFolder);
	}

	public void up() {
		FolderPanel panel = (FolderPanel)this.mainPanel;
		DeskTopFolder folder = panel.getFolder().getParent();
		if(folder != null){
			this.setMainPanel(new FolderPanel(folder));
		}	
	}

	public void upWithSelectedElements(Object[] elements) {
		FolderPanel panel = (FolderPanel)this.mainPanel;
		DeskTopFolder folder = panel.getFolder();
		DeskTopFolder parentFolder = panel.getFolder().getParent();
		if(parentFolder != null){
			this.setMainPanel(new FolderPanel(parentFolder));
			for (int i = 0; i < elements.length; i++) {
				DesktopElement element = (DesktopElement) elements[i];
				folder.remove(element);
				parentFolder.add(element);
			}
		}	
	}

	
	public JToolBar getToolBar() {
		return toolBar;
	}

	public void initialize() {
		rootFolder.initialize();
		setMainPanel(new FolderPanel(rootFolder));
		this.updateAll(rootFolder);
		mainPanel.notifyChange();
	}
	
	public void updateAll() {
		shortCutListPanel.update();
	}
	
	//2007.11.24 Tsukushi Shimizu
	public void updateAll(DeskTopFolder folder) {
		shortCutListPanel.update(folder);
	}

	public void setSelectedElement(DesktopElement selectedElement) {
		shortCutListPanel.setSelectedElement(selectedElement);
		
	}
	public DesktopElement getSelectedElement(){
		return shortCutListPanel.getSelectedElement();
	}
	public Object[] getSelectedElements(){
		return shortCutListPanel.getSelectedElements();
	}

	public GSResource getResource(String uri) {
		return rootFolder.getResource(uri);
	}
}
