package smart_gs.network;

import java.io.IOException;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectHistory;
import smart_gs.swingui.WorkspaceWindow;

public class UploadHistoryWindow extends JFrame {

	private List revisions;
	
	public UploadHistoryWindow(int from, int to) {
		super();
		ProjectHandler handler = ProjectHandler.getInstance();
		HCPProject project = ProjectExplorer.getInstance().getSelectedProjectInRepository();
		
//		this.revisions = handler.getController().fetchHistories(project.name, 0, 0);
//		this.historyPane = new JPanel();
		try {
			List histories = handler.getController().fetchHistories(project.name, from, to);
			String historyString = "";
			for (int i = 0; i < histories.size(); i++) {
				String comment = ((HCPProjectHistory)histories.get(i)).remarks;
				int rev = ((HCPProjectHistory)histories.get(i)).revision;
				String user = ((HCPProjectHistory)histories.get(i)).createdBy.id;
				String date = ((HCPProjectHistory)histories.get(i)).created.toString();
				historyString += "Revision: "+ rev + ", by " + user + " at " + date + "\n   Comment: " + comment + "\n"; 
			}
			JOptionPane.showMessageDialog(ProjectExplorer.getInstance(),
					historyString, "Update History", JOptionPane.INFORMATION_MESSAGE);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (UnauthorizedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	
}
