package smart_gs.network;

import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.custommonkey.xmlunit.DetailedDiff;

public class ShowDifferenceWindow extends JFrame {

	private String localDocumentSource;
	private String repositoryDocumentSource;
	private DetailedDiff diff;

	public ShowDifferenceWindow(String local, String repository,
			DetailedDiff detailedDiff) {
		this.localDocumentSource = local;
		this.repositoryDocumentSource = repository;
		this.diff = detailedDiff;
		JTextArea localSourceTextArea = new JTextArea();
		localSourceTextArea.setText(this.localDocumentSource);
		JTextArea repositorySourceTextArea = new JTextArea();
		repositorySourceTextArea.setText(this.repositoryDocumentSource);
		JTextArea diffTextArea = new JTextArea();
		diffTextArea.setText(this.diff.toString());
		JScrollPane sPane1 = new JScrollPane();
		sPane1.setViewportView(localSourceTextArea);
		JScrollPane sPane2 = new JScrollPane();
		sPane2.setViewportView(repositorySourceTextArea);
		JScrollPane sPane3 = new JScrollPane();
		sPane1.setViewportView(diffTextArea);
		this.setLayout(new BorderLayout());
		JPanel sourcePanel = new JPanel();
		sourcePanel.setLayout(new BorderLayout());
		sourcePanel.add(BorderLayout.WEST, sPane1);
		sourcePanel.add(BorderLayout.EAST, sPane2);
		this.add(BorderLayout.NORTH, sourcePanel);
		this.add(BorderLayout.SOUTH, sPane3);		
	}

}
