package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.util.List;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import jp.ac.nii.hcp.client.core.ImageContentManager;
import jp.ac.nii.hcp.client.net.AuthenticationCache;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPImage;
import jp.ac.nii.hcp.shared.model.HCPProject;


import smart_gs.swingui.ButtonDialog;

public class ImageRegisterDialog extends ButtonDialog {

	private JCheckBox checkBoxForDownload;
	private JCheckBox checkBoxForAddToProject;
	private JTextField imageURLField;
	private JTextField nameField;
	private JPanel centerPanel;
	private ProjectListComboBoxPanel comboBoxPanel;
//	private ProjectListPanel listPanel;
	

	public ImageRegisterDialog(Frame parent) {
		super(parent, "Image Dowload Manager");
		this.setSize(new Dimension(300,300));

		imageURLField = new JTextField();
		imageURLField.setPreferredSize(new Dimension(250, 25));
		JPanel imageURLPanel = new JPanel();
		imageURLPanel.setBorder(new TitledBorder("Image URL"));
		imageURLPanel.add(imageURLField);
		
		nameField = new JTextField();
		nameField.setPreferredSize(new Dimension(250, 25));
		JPanel namePanel = new JPanel();
		namePanel.setBorder(new TitledBorder("Image Name"));
		namePanel.add(nameField);

		JPanel north = new JPanel();
		north.setLayout(new BorderLayout());
		north.add(imageURLPanel, BorderLayout.NORTH);
		north.add(namePanel, BorderLayout.CENTER);

		checkBoxForDownload = new JCheckBox();
		this.checkBoxForDownload.setSelected(true);
		JLabel ask1 = new JLabel();
		ask1.setText("Download to workspace.");
		JPanel cbAndAsk1 = new JPanel();
		cbAndAsk1.setLayout(new BorderLayout());
		cbAndAsk1.add(checkBoxForDownload, BorderLayout.WEST);
		cbAndAsk1.add(ask1, BorderLayout.CENTER);
		
		north.add(cbAndAsk1, BorderLayout.SOUTH);

		checkBoxForAddToProject = new JCheckBox();
		this.checkBoxForAddToProject.setSelected(true);
		JLabel ask2 = new JLabel();
		ask2.setText("Add to project.");
		JPanel cbAndAsk2 = new JPanel();
		cbAndAsk2.setLayout(new BorderLayout());
		cbAndAsk2.add(checkBoxForAddToProject, BorderLayout.WEST);
		cbAndAsk2.add(ask2, BorderLayout.CENTER);		
		List<HCPProject> projects = ProjectHandler.getInstance().getProjectsFromWorkspace();
//		listPanel = new ProjectListPanel(projects, Constants.WORKSPACE, false);
//		cbAndAsk2.add(listPanel, BorderLayout.SOUTH);
		this.comboBoxPanel = new ProjectListComboBoxPanel(projects, Constants.WORKSPACE);
		cbAndAsk2.add(this.comboBoxPanel, BorderLayout.SOUTH);

		centerPanel = new JPanel();
		centerPanel.setLayout(new BorderLayout());
		centerPanel.add(cbAndAsk2, BorderLayout.NORTH);

		
		this.getContentPane().add(north, BorderLayout.NORTH);
		this.getContentPane().add(centerPanel, BorderLayout.CENTER);
	}

	@Override
	public void ok() {
		ProjectHandler handler = ProjectHandler.getInstance();
		handler.setAction(ProjectAction.RESISTER_IMAGE);
		String name = this.nameField.getText();
		String url = this.imageURLField.getText();
		boolean download = this.checkBoxForDownload.isSelected();
		boolean addToProject = this.checkBoxForAddToProject.isSelected();
		int index = this.comboBoxPanel.getSelectedIndex();
		if (addToProject && !download) {
			JOptionPane.showMessageDialog(this, "Chedk Download option if you want to add the image to project.", "ERROR", JOptionPane.ERROR_MESSAGE);
			return;						
		} else if (addToProject && index < 0) {
			JOptionPane.showMessageDialog(this, "No project is selected.", "ERROR", JOptionPane.ERROR_MESSAGE);
			return;			
		}
		if (!validName(name)) {
			JOptionPane.showMessageDialog(this, "The name is not valid.\nIt should be a string composed of not over 16 alphabets and/or numerals.", "ERROR", JOptionPane.ERROR_MESSAGE);
			return;
		}
		if (!handler.authenticated()) {
			handler.authenticate();
		} else {
			ImageContentManager icm = handler.getImageManager();
			AuthenticationCache auth = handler.getAuthenticationCache();
			try {
				HCPImage image = icm.add(auth.user, name, url);
				if (download) {
					String path = image.getPath();
					try {
						icm.download(path, null);
					} catch (IOException e) {
						new ShowResultDialog("Register Image",e);
						e.printStackTrace();
					}
					if (addToProject) {
						HCPProject project = this.comboBoxPanel.getSelectedProject();
						handler.addImages(project);
					}
				}
			} catch (IOException e) {
				new ShowResultDialog("Register Image",e);
				e.printStackTrace();
			} catch (HCPClientException e) {
				new ShowResultDialog("Register Image",e);
				e.printStackTrace();
			}
		}
		this.dispose();		
	}

	@Override
	public void cancel() {
		this.dispose();
	}
	
	private static boolean validName(String name) {
		return name.matches("[0-9a-zA-Z]+") && name.length() <= 16;
	}

}

