package smart_gs.network;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import jp.ac.nii.hcp.client.core.HCPController;
import jp.ac.nii.hcp.client.core.ProjectEditor;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPProject;
import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;

public class ConvertGsxFileToHCPProjectActionListener implements ActionListener {

	@Override
	public void actionPerformed(ActionEvent e) {
		JFileChooser fileChooser = new JFileChooser(".");
		fileChooser.setDialogTitle("Select a gsx file.");
		fileChooser.addChoosableFileFilter(new smart_gs.logical.filter.GSXFileFilter());
		int option = fileChooser.showDialog(WorkspaceWindow.getInstance(), "Select");
		if (option != JFileChooser.APPROVE_OPTION) return;
		File file = fileChooser.getSelectedFile();
		String name = JOptionPane.showInputDialog("Name:");
		try {
			this.convert(file, name);
		} catch (ZipException e1) {
			e1.printStackTrace();
		} catch (IOException e1) {
			e1.printStackTrace();
		}
	}

	private void convert(File file, String name) throws ZipException, IOException {
		ProjectHandler handler = ProjectHandler.getInstance();
		HCPController controller = handler.getController();
		ZipFile gsxFile = new ZipFile(file);
		ZipEntry gsxSpread = gsxFile.getEntry("spread.xml");
		if (gsxSpread == null){
			JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(), file.getName() + ": Invalid gsx file.");
			return;
		}
		InputStream is = gsxFile.getInputStream(gsxSpread);
		String source = convertString(is);

		gsxFile.close();

		try {
			controller.createProject(name);
			ProjectEditor editor = controller.openProject(name);
			editor.addDocument("main", source, "");
			ProjectExplorer.getInstance().update();
			HCPProject project = controller.getProject(name);
			String path = Preference.getInstance().getWorkspaceDirectory();
			WorkspaceWindow.getInstance().restoreProject(project);
		} catch (HCPClientException e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(), e);
		}
		
	}

	private static String deleteExtension(String name) {
		int index = lastIndexOf(".", name);
		if (index == -1) {
			return name;
		} else {
			return name.substring(0,index);
		}
	}

	private static int lastIndexOf(String dot, String fileName) {
		int i = fileName.indexOf(dot);
		if (i == -1) {
			return -1;
		} else {
			return i + 1 + lastIndexOf(dot, fileName.substring(i+1));
		}
	}
	public static String convertString(InputStream is) throws IOException {
		BufferedReader reader =
			new BufferedReader(new InputStreamReader(is, "UTF-8"));
		StringBuilder sb = new StringBuilder();
		char[] b = new char[1024];
		int line;
		while (0 <= (line = reader.read(b))) {
			sb.append(b, 0, line);
		}
		return sb.toString();
	}	
}