package smart_gs.menu;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.GSConstants;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.toolbar.ImageToolBarComponent;
import smart_gs.swingui.toolbar.ImageToolBarComponent.IMAGETOOLBARCOMPONENT_TYPE;
import smart_gs.swingui.toolbar.action.LineSegEditorChangeIndexesActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDeleteActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDivideActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDrawPolygonActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDrawRectangleActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorEditVertexActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorMoveAndResizeActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorRotateActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorSelectActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorSemiAutomaticLineSegmentationActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorUndoRedoActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorZoomInOutActionListener;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsInXMLFormatAction;

public class LineSegToolMenu extends JMenu {

	private LineSegEditor editor;

	public LineSegToolMenu(String string, LineSegEditor parent) {
		super("Tool");

		this.editor = parent;
		
		JMenuItem undo = new JMenuItem("Undo");
		undo.addActionListener(this.editor.lsgEditor_undo);
		undo.setToolTipText("Undo the last change on line segments");
		undo.setAccelerator(KeyStroke.getKeyStroke("ctrl Z"));
		this.add(undo);
		
		JMenuItem redo = new JMenuItem("Redo");
		redo.addActionListener(this.editor.lsgEditor_redo);
		redo.setToolTipText("Redo the last undo");
		redo.setAccelerator(KeyStroke.getKeyStroke("ctrl Y"));
		this.add(redo);

		JMenuItem zoomIn = new JMenuItem("Zoom IN");
		zoomIn.addActionListener(this.editor.lsgEditor_zoomIn);
		zoomIn.setToolTipText("Zoom in");
		this.add(zoomIn);

		JMenuItem zoomOut = new JMenuItem("Zoom OUT");
		zoomOut.addActionListener(this.editor.lsgEditor_zoomOut);
		zoomOut.setToolTipText("Zoom out");
		this.add(zoomOut);

		JMenuItem  select = new JMenuItem("Select");
		select.addActionListener(this.editor.lsgEditor_select);
		select.setToolTipText("Select Line Segment");
		this.add(select);
		select.setSelected(true);

		this.addSeparator();

		JMenuItem drawAuto1 = new JMenuItem("Auto Draw Rectangles");
		drawAuto1.addActionListener(this.editor.lsgEditor_autoDrawRectangles);
		drawAuto1.setToolTipText("Semi-auto rectangular line segment drawer");
		this.add(drawAuto1);

		JMenuItem drawRect = new JMenuItem("Draw Rectangle");
		drawRect.addActionListener(this.editor.lsgEditor_drawRectangle);
		drawRect.setToolTipText("Draw rectangular line segment");
		this.add(drawRect);

		JMenuItem draw = new JMenuItem("Draw Polygon");
		draw.addActionListener(this.editor.lsgEditor_drawPolygon);
		draw.setToolTipText("Draw line segment");
		this.add(draw);

		this.addSeparator();

		JMenuItem cut = new JMenuItem("Divide");
		cut.addActionListener(this.editor.lsgEditor_divide);
		cut.setToolTipText("Divide Line Segment by line");
		this.add(cut);

		JMenuItem  editVertex = new JMenuItem("Edit Vertex");
		editVertex.addActionListener(this.editor.lsgEditor_editVertex);
		editVertex.setToolTipText("Edit Vertex");
		this.add(editVertex);
//		editVertex.setSelected(true);
		editVertex.setEnabled(false);

		JMenuItem delete0 = new JMenuItem("Delete");
		delete0.addActionListener(this.editor.lsgEditor_delete);
		delete0.setToolTipText("Delete line segments");
		this.add(delete0);

		JMenuItem delete1 = new JMenuItem("Delete Narrower Lines");
		delete1.addActionListener(this.editor.lsgEditor_deleteNarrowerLines);
		delete1.setToolTipText("Delete line segments narrower than specified line segments");
		this.add(delete1);

		JMenuItem changeSize = new JMenuItem("Move & Resize");
		changeSize.addActionListener (this.editor.lsgEditor_moveAndResize);
		changeSize.setToolTipText("Mode & Resize");
		this.add(changeSize);
		changeSize.setEnabled(false);

		JMenuItem rotate = new JMenuItem("Rotate");
		rotate.addActionListener (this.editor.lsgEditor_rotate);
		rotate.setToolTipText("Rotate line segments");
		this.add(rotate);
		rotate.setEnabled(false);


		JMenuItem move = new JMenuItem("Change Index");
		move.addActionListener(this.editor.lsgEditor_changeIndex);
		move.setToolTipText("Change indexes");
		this.add(move);
	}
}
