package smart_gs.logical.filter;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class GSXFileFilter extends FileFilter {

	@Override
	public boolean accept(File file) {
		String fileName = file.getName();
		if(file.isDirectory()){
			return true;
		}
		
		if (file.getName().toLowerCase().endsWith(".gsx")) {
			return true;
		}
		return false;
	}

	@Override
	public String getDescription() {
		return "GSX File";
	}	
	
}
