package smart_gs.logical;

import java.awt.BorderLayout;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

import reasoning_web.logical.NotMarkupException;
import smart_gs.logical.visitor.Visitor;

// GSResource can be made a zombie. A zombie GSResource is saved just as its URI not as the resource itself.
// Thus a kind of GSResource is necessary to restore a GSResource of the saved URI.
// This class is for it. However, zombie GSResources for connections are not represented by this class,
// but represented by zombie flags of GSResourcePointers. 

public class ZombieGSResourceForRestoring extends GSResource  {

	String deadURI;
	static ArrayList<ZombieGSResourceForRestoring> allZombies = new ArrayList<ZombieGSResourceForRestoring>();

	private ZombieGSResourceForRestoring(String uri, String deadUri) {
		super();
		this.setURIs(uri,uri);
		this.deadURI = deadUri;
		ZombieGSResourceForRestoring.addZombie(this);
	}
	
	private static void addZombie(ZombieGSResourceForRestoring zombie) {
		ZombieGSResourceForRestoring.allZombies.add(zombie);
	}

	public static ZombieGSResourceForRestoring getZombie(String deadURI) {
		String tmp = new String(deadURI);
		if (tmp.startsWith("smart://")) {
			tmp = tmp.substring(8);
		} else {
			tmp = new String("::ERROR_ON_DEAD_URI::") + tmp;
			deadURI = tmp;
		}
		String uri = deadURI;
		ZombieGSResourceForRestoring zmb = searchZobmie(uri);
		if (null != zmb) {
			return zmb;
		} else {
			return new ZombieGSResourceForRestoring(uri, deadURI);
		}
	}
	
	private static ZombieGSResourceForRestoring searchZobmie(String uri) {
		int size = allZombies.size();
		for (int i = 0; i < size; i++) {
			if (uri.equals(allZombies.get(i))) {
				return allZombies.get(i);
			}
		}
		return null;
	}

	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}

	@Override
	public String getSource() throws NotMarkupException {
		return null;
	}

	@Override
	public String getTypeString() {
		return URIObject.ZOMBIE;
	}

	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	
	public String getDeadURI() {
		return this.deadURI;
	}
	
	public void setDeadURI(String deadURI) {
		this.deadURI = deadURI;
	}
	
	public static ArrayList<ZombieGSResourceForRestoring> getAllZombies() {
		return ZombieGSResourceForRestoring.allZombies;
	}

	public JPanel createElementViewPanelForLocalView() {
		Image image=null;
		try {
			image = ImageIO.read(new File("./icons/zombie.png"));
		} catch (IOException e) {
			System.out.println("Failed to generate error message image! In Zombie.java");
		}
		
		JLabel label = new JLabel();
		label.setHorizontalAlignment(JLabel.CENTER);
		ImageIcon icon = new ImageIcon(image);
		label.setIcon(icon);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.add(label,BorderLayout.CENTER);
		return panel;
	}
	//None An old version Zombie is a Zombie.
	@Override
	public void makeItZombie() {
		//None
	}

	@Override
	public boolean isZombie() {
		return true;
	}

	@Override
	public void resuscitate() {
		// None
	}
}