package smart_gs.image_search.normal.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.util.ImageAdjuster;
import sml_editor.logical.LineDirection;

@SuppressWarnings("serial")
public class TranscriptionToolNo1Frame extends JFrame{
	
	
	private List<SearchResult> results;
	private Image queryImage;
	private LineDirection lineDirection;
	private AbstractTranscriptionPanel transcriptionPanel;
	private JScrollPane scrollPane;
	private JTextField transcriptionTextField;

	protected List<SearchResult> selectedResults;
	private JPanel mainPanel;
	/*"Bucket"
	 * 20071109 田村
	 * 削除された検索候補のリストを追加
	 */
	protected List<SearchResult> removedResults;
	
	public TranscriptionToolNo1Frame(Image queryImage,List<SearchResult> results,LineDirection lineDirection){
		super("Transcription Tool No1");
		this.results = results;
		this.lineDirection = lineDirection;
		 // 20071110 田村
		this.removedResults = new ArrayList<SearchResult>();
		/*
		 * 新たな検索結果だけを入れる
		 */

		
		this.selectedResults = new ArrayList<SearchResult>();
	
		this.queryImage = ImageAdjuster.adjust(queryImage,this.lineDirection, 100.0);
		
		
		this.build();
			
		this.setLocation(70,120);
//		this.pack();
		this.setPreferredSize(new Dimension(500,500));
		this.setVisible(true);
	}


	// 20071109 田村
	public List<SearchResult> getRemovedResults() {
	    return removedResults;
	}
	
	public void setResultPanel(AbstractTranscriptionPanel transcriptinPanel) {

			mainPanel.remove(this.transcriptionPanel);

		this.transcriptionPanel = transcriptinPanel;


		mainPanel.add(this.transcriptionPanel,BorderLayout.CENTER);


	}

	public List<SearchResult> getSelectedResults() {
		return this.selectedResults;
	}

	private void build(){

		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		
		JPanel queryPanel = new QueryPanel(queryImage, this.lineDirection);
		
		this.scrollPane = new JScrollPane();
		if (this.lineDirection == LineDirection.HORIZONTAL) {
			this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
			this.scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		} else {
			this.scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
			this.scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
		}

		this.transcriptionPanel = new TranscriptionToolNo1SegmentsPanel(this,this.results,this.queryImage,this.lineDirection);
		
		this.scrollPane.setViewportView(this.transcriptionPanel);
		
		mainPanel = new JPanel();
		
		JPanel buttonPanel = new JPanel();
		JButton back = new JButton("back");
		back.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				transcriptionPanel.back();
				scrollPane.getVerticalScrollBar().setValue(0);
				validate();
			}
		});
		JButton next = new JButton("next");
		next.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				transcriptionPanel.next();
				scrollPane.getVerticalScrollBar().setValue(0);
				validate();
			}
		});

		buttonPanel.add(back);
		buttonPanel.add(next);
		
		mainPanel.setLayout(new BorderLayout());
		//2007/10/15 kazuhiro kobayashi 検索したページを表示するため
//		mainPanel.add(queryPanel,BorderLayout.NORTH);
		/*
		 * 検索したページの表示をする
		 */
		JPanel topPanel = new JPanel();
		topPanel.setLayout(new BorderLayout());
		transcriptionTextField = new JTextField(40);
		JButton transcribeButton = new JButton("Transcribe");
		transcribeButton.addActionListener(new TranscriptionToolNo1Listner(this,this.results,this.queryImage));
		JPanel southPanel = new JPanel();
		southPanel.setLayout(new FlowLayout());
		
		if (this.lineDirection == LineDirection.HORIZONTAL) {
			topPanel.add(queryPanel,BorderLayout.CENTER);
			southPanel.add(new JLabel("Transcription Text: "));
			southPanel.add(transcriptionTextField);
			southPanel.add(transcribeButton);			
			topPanel.add(southPanel,BorderLayout.SOUTH);
			mainPanel.add(topPanel,BorderLayout.NORTH);
		} else {
			topPanel.add(queryPanel,BorderLayout.CENTER);
			topPanel.add(transcriptionTextField,BorderLayout.SOUTH);
			mainPanel.add(topPanel, BorderLayout.WEST);
		}
		
		mainPanel.add(this.transcriptionPanel,BorderLayout.CENTER);

		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
		
		JPanel northPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		
		this.getContentPane().add(northPanel,BorderLayout.NORTH);

		this.getContentPane().add(buttonPanel,BorderLayout.SOUTH);
		this.pack();
	}
	

	
	// 20071109 田村 -- 検索候補削除の更新
	public void updateRemoved() {
//	   this.bucketFrame.setRemovedResults(this.removedResults);
	}
	// 20110423 shayashi
	public Image getQueryImage() {
		return queryImage;
	}
	
	public LineDirection getLineDirection() {
		return lineDirection;
	}


	public JTextField getTranscriptionTextField() {
		return transcriptionTextField;
	}


	public void setTranscriptionTextField(JTextField transcriptionTextField) {
		this.transcriptionTextField = transcriptionTextField;
	}
}


