/* $Id: BucketFrame.java 568 2012-09-11 15:43:44Z shayashi $ */
package smart_gs.image_search.normal.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JScrollPane;


import smart_gs.image_search.MultiSearchAction;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.reasoning_web.desktop.logical.ShortCut;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import smart_gs.swingui.ButtonFrame;
import smart_gs.swingui.CreateShortCutDialog;

import smart_gs.logical.Spread;
import smart_gs.logical.StandardTextDocument;
import smart_gs.spread_selection.SetScopePanel;;

@SuppressWarnings("serial")
public class BucketFrame extends ButtonFrame{
	
	private BucketPanel bucketPanel;
	private List<SearchResult> previousResults;
	
	// 20071109 田村 -- 外された検索候補のリストを追加
	private List<SearchResult> removedResults;
	// private int removeSize;
	
	private int previousSize;
	//検索範囲の指定
	private SetScopePanel scopePanel;
	
	public BucketFrame(QueryBucket bucket){
		this(bucket,null,"Query Bucket");
	}

	public BucketFrame(QueryBucket bucket,String title, List<SearchResult> results, List<SearchResult> removedResults, int size) {
		this(bucket,null,title);
		previousResults = results;
		this.previousSize = size;
		this.setRemovedResults(removedResults);
		// this.removedResults = removedResults;
	}
	
	public BucketFrame(QueryBucket bucket,Frame parent, String title) {
		super(parent, title);
		JScrollPane scrollPane = new JScrollPane();
		this.bucketPanel = new BucketPanel(this,bucket);
		this.okButton.setText("Search");
		
		scrollPane.setViewportView(this.bucketPanel);
		
		this.getContentPane().add(scrollPane,BorderLayout.CENTER);
		
		JButton register = new JButton("Register");
		register.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				register();
			}
		});
		this.getButtonPanel().add(register, 1);
		
		/*
		 * 検索範囲の指定
		 */
		this.scopePanel = new SetScopePanel(true);
		this.getButtonPanel().add(scopePanel);
	}
	
	/* 
	 * 20071109 田村
	 * 外された検索候補の更新
	 */
	public void setRemovedResults(List<SearchResult> removedResults) {
	    // this.removeSize = removedResults.size();
	    this.removedResults = removedResults;
	}

	@Override
	public void cancel() {
		this.dispose();
	}
	public void register(){
		QueryBucket bucket = this.bucketPanel.getBucket();
		/*
		 *  名前とメモ書きを残す
		 */
		CreateShortCutDialog dialog = new CreateShortCutDialog(this);

		dialog.setVisible(true);
		String name = dialog.getName();
		StandardTextDocument doc = dialog.getDocument();
		ShortCut shortcut = new ShortCut(bucket,name,doc);
		ReasoningWebDesktop.getInstance().getRootFolder()
			.add(shortcut);
	}
	
	@Override
	public void ok() {
	    /*
	     * 20071109 田村
	     * previousResults から外された検索候補を除く
	     * 
	     */
	    List<SearchResult> pResults = new ArrayList<SearchResult>();
		//変更　田村
	    for (int i = 0; i < previousResults.size(); i++) {
		if (!removedResults.contains(previousResults.get(i))) {
		    previousResults.get(i).setWasShown(true);
		    pResults.add(previousResults.get(i));
		}
	    }
	    // this.previousSize = pResults.size();
		/*
		 * 検索範囲の指定の処理を追加
		 */
	    List<Spread> spreads = this.scopePanel.getSpreadsToSearch();
		QueryBucket bucket = this.bucketPanel.getBucket();
		System.out.println("images to search: " + spreads);
//		MultiSearchAction action = new MultiSearchAction(bucket,SpreadTree.getInstance().getDSCSpreads());
		MultiSearchAction action = new MultiSearchAction(bucket,this.scopePanel.getDSCSpreads(spreads));
		
		if(pResults != null){
			action.setPreviousResults(pResults, this.previousSize);
		}
		action.execute();
		//2007/10/11 kazuhiro kobayashi
		//検索対象のページを表示するため
		new SearchResultViewer(bucket,action.getResults(), this.scopePanel.getSelectedPage()).setVisible(true);
		this.dispose();
	}
}
