package smart_gs.drawing_tool.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import javax.swing.ImageIcon;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import smart_gs.GSConstants;

import smart_gs.logical.URICreator;

public class CloseUpRectangleView extends View {

	protected Rectangle2D rectangle;
	
	public CloseUpRectangleView(Rectangle2D rectangle){
		super();
		this.rectangle = rectangle;
		this.defaultColor = Color.blue;
	}
	public CloseUpRectangleView(Rectangle2D rectangle, boolean isProtected){
		this(rectangle);
		this.isProtected = isProtected;
	}
	public CloseUpRectangleView(Rectangle2D rectangle,boolean isSelected,boolean isEmphasized, boolean isProtected){
		this(rectangle);
		this.isSelected = isSelected;
		this.isEmphasized = isEmphasized;
		this.isProtected = isProtected;
	}

	@Override
	public boolean contains(Point2D point) {
		return this.rectangle.contains(point);
	}
	
	
	
	@Override
	public void drawShape(Graphics2D g) {
		g.draw(this.rectangle);
		if (this.isSelected()){
			this.drawSelectedIcon(g);
		}
	}

	@Override
	public int getType() {
		return View.RECTANGLE;
	}

	@Override
	public void moveBy(Point2D d) {
		double x = this.rectangle.getX();
		double y = this.rectangle.getY();
		double width = this.rectangle.getWidth();
		double height = this.rectangle.getHeight();
		this.rectangle = new Rectangle2D.Double(x+d.getX(),y+d.getY(),width,height);
	}
	
	@Override
	public View enlargedView(double ratio, double gapX, double gapY) {
		double x = this.rectangle.getX();
		double y = this.rectangle.getY();
		double w = this.rectangle.getWidth();
		double h = this.rectangle.getHeight();
		Rectangle2D rect = new Rectangle2D.Double(x*ratio+gapX,y*ratio+gapY,w*ratio,h*ratio);
		return new CloseUpRectangleView(rect,this.isSelected,this.isEmphasized, this.isProtected);
	}
	public Rectangle2D getRectangle2D() {
		return this.rectangle;
	}
	@Override
	public String getTypeString() {
		return URICreator.CLOSE_UP_RECTANGLE;
	}
	@Override
	public void drawLinkedShape(Graphics2D g, Image image) {
		this.draw(g);
		this.drawLinkIcon(g, image);
	}
	@Override
	public void drawTemporaryShape(Graphics2D g) {
		this.draw(g);
		this.drawTemporaryIcon(g);
	}
	@Override
	public Element createXMLElement(Document document) {
		return null;
	}
	public static View restore(Element elem) {
		return null;
	}
	public void setRectangle(Rectangle rectangle) {
		this.rectangle = rectangle;
	}
	
	@Override
	public Point getCenterPoint() {
		return new Point((int)this.rectangle.getCenterX(), (int)this.rectangle.getCenterY());
	}
	@Override
	public String getTypeStringForDisplay() {
		return "Close-Up Rectangle";
	}
	@Override
	public void drawLinkIcon(Graphics2D g, Image image) {
	}

	@Override
	public void drawTemporaryIcon(Graphics2D g) {
		Image image = new ImageIcon(GSConstants.ICON_PATH + "Temporary.png").getImage();
		Rectangle rect = this.getRectangle();
		int w = image.getWidth(null) / 3;
		int h = image.getHeight(null) / 3;
		int x = (int)(rect.getX() + rect.getWidth() - w/3);
		int y = (int)(rect.getY()) - h/2;
		g.drawImage(image, x, y, w, h, null);
	}
	@Override
	public void drawSelectedIcon(Graphics2D g) {
		ImageIcon selected = new ImageIcon(GSConstants.ICON_PATH + "selected_mark.png");
		Image selectedImage = selected.getImage();
		Rectangle rect = this.getRectangle();
		int w = (int)(selectedImage.getWidth(null) / 2.5);
		int h = (int)(selectedImage.getHeight(null) / 2.5);
		int x = (int)(rect.getX()) - w;
		int y = (int)(rect.getY()) - h;
		g.drawImage(selectedImage, x, y, w, h, null);
		ImageIcon closeUp = new ImageIcon(GSConstants.ICON_PATH + "region_close_up.png");
		Image closeUpImage = closeUp.getImage();
		Rectangle closeUpImageRectangle = this.closeUpImageRectangle();
		int w2 = (int)closeUpImageRectangle.getWidth();
		int h2 = (int)closeUpImageRectangle.getHeight();
		int x2 = (int)closeUpImageRectangle.getX();
		int y2 = (int)closeUpImageRectangle.getY();
		g.drawImage(closeUpImage, x2, y2, w2, h2, null);
	}
	
	@Override
	protected Rectangle closeUpImageRectangle() {
		Rectangle rect = this.getRectangle();
		ImageIcon closeUp = new ImageIcon(GSConstants.ICON_PATH + "region_close_up.png");
		Image closeUpImage = closeUp.getImage();
		int w = (int)(closeUpImage.getWidth(null) / 4.5);
		int h = (int)(closeUpImage.getHeight(null) / 4.5);
		int x = (int)(rect.getX()) - (int)(w * (2/3.0));
		int y = (int)(rect.getY()) + (int)(rect.getHeight() - (h * (1/3.0)));
		return new Rectangle(x, y, w, h);
	}

	@Override
	public boolean containsInCloseUpIcon(Point2D point) {
		Rectangle closeUpImageRectangle = this.closeUpImageRectangle();
		int w = (int)closeUpImageRectangle.getWidth();
		int h = (int)closeUpImageRectangle.getHeight();
		int x = (int)closeUpImageRectangle.getX();
		int y = (int)closeUpImageRectangle.getY();
		double px = point.getX();
		double py = point.getY();
		return px >= x && px <= x+w && py >= y && py <= y+h;
	}
	@Override
	public void drawInBasketShape(Graphics2D g) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void drawRWShape(Graphics2D g) {
		// TODO Auto-generated method stub
		
	}
}
