package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import reasoning_web.logical.Connection;
import smart_gs.logical.GSResource;
import smart_gs.logical.Region;
import smart_gs.logical.TextSegment;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;

public class ShowInRWAction implements ActionListener {
	
	private GSResource region = null;
	private Connection connection = null;
	private TextSegment segment = null;

	public ShowInRWAction(Region region) {
		this.region = region;
	}

	public ShowInRWAction(Connection connection) {
		this.connection = connection;
	}

	public ShowInRWAction(TextSegment segment) {
		this.segment  = segment;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		ReasoningWebFrame rwf = ReasoningWebFrame.getInstance();
		if (this.region != null) {
			rwf.getElementsPanel().setElement(this.region);
		} else if (connection != null) {
			rwf.getElementsPanel().setElement(this.connection);
		} else {
			rwf.getElementsPanel().setElement(this.segment);
		}	
		rwf.setVisible(true);
	}
}
