/* $Id: MemoPadDeleteArrowAction.java 1058 2016-01-17 17:09:20Z shayashi $ */
package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.region.MemoPadRegion;
import smart_gs.drawing_tool.view.MemoPadView;
import javax.swing.JOptionPane;

public class MemoPadDeleteArrowAction implements ActionListener {
	
	//private static final long serialVersionUID = 1L;
	private Region region;
	private SpreadCanvas canvas;
	
	public MemoPadDeleteArrowAction(Region region, SpreadCanvas canvas) {
		this.region = region;
		this.canvas = canvas;
	}
	

	@Override
	public void actionPerformed(ActionEvent e) {
		((UniSelectedState)canvas.getImageLabel().getState()).setDeleteArrowPointMode(true);
		((MemoPadRegion)region).setDeleteArrowPointMode(true);
	}

}
