package smart_gs.connection;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import reasoning_web.logical.Connection;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.logical.Region;
import smart_gs.logical.TextSegment;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.RWGlobalViewPanel;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.reasoning_web.swingui.ZombiePanel;
import smart_gs.reasoning_web.swingui.elementViewPanelListener;
import smart_gs.reasoning_web.swingui.action.ShowExplanatoryAction;
import smart_gs.swingui.ButtonFrame;
import smart_gs.swingui.WorkspaceWindow;

@SuppressWarnings("serial")
public class lastConnectionToConfirmAndEditFrame extends ButtonFrame {
	private JTextField nameField;
	private Connection connection;
	private String connectionName;
	private boolean confirmed = false;
	private boolean cancel_disabled = false;
	
	private static final int BOX_HEIGHT = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;
	
	public lastConnectionToConfirmAndEditFrame(Connection new_connection,String title) {
		super("",title);
		this.addWindowListener(new LastConnectionToConfirmAndEditFrameWindowListener(this));
		JSplitPane contentsPane = new JSplitPane();
		JSplitPane leftContentPane = new JSplitPane();
		GSResourcePointer source_pointer = new_connection.getSourcePointer();
		GSResourcePointer target_pointer = new_connection.getTargetPointer();
		GS_RWElement sourceElement;
		GS_RWElement targetElement;
		if (! source_pointer.isZombified()) {
			sourceElement = (GS_RWElement)source_pointer.getGSResource();
		} else {
			sourceElement = null;
		}
		if (! target_pointer.isZombified()) {
			targetElement = (GS_RWElement)target_pointer.getGSResource();
		} else {
			targetElement = null;
		}
		connection = new_connection;
		connectionName = new_connection.getName();

		JPanel sourceElementViewPanel = null;
		JPanel targetElementViewPanel = null;
		try {
			if (sourceElement == null) {
				sourceElementViewPanel = ZombiePanel.getZombieElementViewPanelForLocalView(source_pointer.getURI());;
			} else if (sourceElement instanceof Region) {
				sourceElementViewPanel = ((Region)sourceElement).createElementViewPanelForLocalView();
			} else if (targetElement instanceof TextSegment) {
				sourceElementViewPanel =((TextSegment)sourceElement).createElementViewPanelForLocalView();
			} else {
				sourceElementViewPanel = sourceElement.createElementViewPanel(BOX_HEIGHT,BOX_HEIGHT);
			}
			if (targetElement == null) {
				targetElementViewPanel = ZombiePanel.getZombieElementViewPanelForLocalView(target_pointer.getURI());;
			} else if (targetElement instanceof Region) {
				targetElementViewPanel = ((Region)targetElement).createElementViewPanelForLocalView();
			} else if (targetElement instanceof TextSegment) {
				targetElementViewPanel =((TextSegment)targetElement).createElementViewPanelForLocalView();
			} else {
				targetElementViewPanel = targetElement.createElementViewPanel(BOX_HEIGHT,BOX_HEIGHT);
			}
		} catch (NoWayToShowException e) {
			e.printStackTrace();
		}
		
		if (sourceElement != null) sourceElementViewPanel.addMouseListener(new elementViewPanelListener(sourceElementViewPanel,sourceElement));
		if (targetElement != null) targetElementViewPanel.addMouseListener(new elementViewPanelListener(targetElementViewPanel,targetElement));
		
		sourceElementViewPanel.setBorder(new TitledBorder("Source"));
		leftContentPane.setLeftComponent(sourceElementViewPanel);
		targetElementViewPanel.setBorder(new TitledBorder("Target"));
		leftContentPane.setRightComponent(targetElementViewPanel);
		contentsPane.setLeftComponent(leftContentPane);

		try {
			JPanel panel = new JPanel();
			panel.setLayout(new GridLayout(2,1));
			panel.setPreferredSize(new Dimension((int)(BOX_HEIGHT*1.5),BOX_HEIGHT));
			
			nameField = new JTextField(15);
			nameField.setBorder(new TitledBorder("Connection Name"));
			nameField.setText(connectionName);
			panel.add(nameField);		
			
			JButton editButton = new JButton("Explantory Note");
			GSExplanatoryNote expNote = (GSExplanatoryNote)new_connection.getExplanatoryNote();
			editButton.addActionListener(new ShowExplanatoryAction(expNote));
			panel.add(editButton);
			
			contentsPane.setRightComponent(panel);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		this.getContentPane().add(contentsPane,BorderLayout.CENTER);
		
    	PointerInfo pointerInfo = MouseInfo.getPointerInfo();
    	Point p = pointerInfo.getLocation();
    	this.setLocation(p.x-(int)(BOX_HEIGHT*1.3),p.y-BOX_HEIGHT);
	
		this.validate();
		this.pack();
		this.setVisible(true);
		
	}
	//2007/11/12 kazuhiro kobayashi
	public void ok(){
		this.confirmed = true;
		this.notifyCurrentStateOfTextPane();
		WorkspaceWindow.getInstance().initializeGUI();
		this.dispose();
//		Connection connection = RWGlobalViewPanel.getInstance().getSelectedConnection();
//		ReasoningWebFrame.getInstance().getElementsPanel().getConnectionTable()
//			.setSelectedConnection(connection);
//		ReasoningWebFrame.getInstance().repaint();
	}
	public void cancel(){
		this.dispose();
	}

	public void notifyCurrentStateOfTextPane(){
		connectionName = this.nameField.getText();		
		connection.setName(connectionName);
	}
	
	public void setCancelDisabled () {
		this.cancel_disabled = true;
	}
	
	class LastConnectionToConfirmAndEditFrameWindowListener extends WindowAdapter {
		
		private lastConnectionToConfirmAndEditFrame frame;
		public LastConnectionToConfirmAndEditFrameWindowListener(lastConnectionToConfirmAndEditFrame f) {
			super();
			this.frame = f;
		}
		@Override
		public void windowClosed(WindowEvent e) {
			
			if (!frame.confirmed && !frame.cancel_disabled) {
				GS_RWRepository.getInstance().removeLastConnection();
				ReasoningWebFrame.getInstance().reload();
				ReasoningWebFrame.getInstance().repaint();
			}
		}
		
	}
}
