/* $Id: SmartGS.java 878 2014-09-10 01:50:59Z shayashi $ */
package smart_gs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

import javax.imageio.ImageIO;

import smart_gs.image_search.GSSearchEngine;
import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.DscSearch;

public class SmartGS {
	
	private static boolean dscFolderSetting = false;
	private static String imageSearchExefilePathString = "";
	private static String imageSearchAssignlistfilePathString = "";
	
	/**
	 * @return the dscFolderSetting
	 */
	public static boolean isDscFolderSetting() {
		return dscFolderSetting;
	}
	/**
	 * @return the exefilePathString
	 */
	public static String getImageSearchExefilePathString() {
		return imageSearchExefilePathString;
	}

	/**
	 * @param index 
	 * @return the assignlistfilePathString
	 */
	public static String getImageSearchAssignlistfilePathString(Integer index) {
		return imageSearchAssignlistfilePathString.concat(index.toString());
	}


	public static void main(String[] args) {
		//20080118 North Grid Add
		
//		String formatNames[] = ImageIO.getReaderFormatNames();
//		
//		List<String> l = Arrays.asList(formatNames);
//		Iterator it = l.iterator();
//		while(it.hasNext()) {
//			System.out.println(it.next());
//		}
		
		
		ArrayList<String> temp = new ArrayList<String>();
		if( args.length > 0 ){
			for(int i = 0; i < args.length; i++){
				if (args[i].startsWith("-")){
					if (!(args[i].equals("-p") || args[i].equals("-dscfolderpathsetting"))) {
						System.out.println("Illegal option " + args[i] + " is neglected.");
						System.out.println("-p: specifying preference file");
						System.out.println("-dscfolderpathsetting: old sytle Date Directories & Files Setting");
					}
				}
			}
			
			for(int j = 0; j < args.length; j++){
				if( args[j].equals("-p") ){
					if( j < args.length-1 ){
						String preferenceFile = args[j+1];
						if(new File(preferenceFile).exists()){
							Preference.setPreferenceFile(preferenceFile);
							System.out.println("Loading from " + preferenceFile + ".");
						}else{
							System.out.println("can't find " + preferenceFile + ". Loading default...");
						}
					}else{
						System.out.println("Invalid parameter. Please set \"-p <preference file>\".  Loading default...");
					}
				}else{
					temp.add(args[j]);
				}
			}
			
			for(int k = 0; k < args.length; k++){
				if (args[k].equals("-dscfolderpathsetting")){
					dscFolderSetting = true;
					break;
				}
			}
		}
		

		File fileCurrent=new File(".");

//		imageSearchExefilePathString = CanonicalPathString.get(fileCurrent) + "/DscSearch.exe";
		imageSearchExefilePathString = DscSearch.getPath();

		imageSearchAssignlistfilePathString = CanonicalPathString.get(fileCurrent) + "/temp/assignlist";
		System.out.println("DscSearch mode with using default path: exefile=\"" + imageSearchExefilePathString + "\", assignlistfile=\"" + imageSearchAssignlistfilePathString + "\"");

		WorkspaceWindow workspaceWindow = WorkspaceWindow.getInstance();
		int status = workspaceWindow.getPreferenceLoadStatus();
		
		if (status != 0) {
			workspaceWindow.dispose();
		} else {
			workspaceWindow.setVisible(true);
			workspaceWindow.setFileOpened(true);
		}
	}

}

