/* $Id: Connection.java 1072 2016-02-27 04:27:27Z shayashi $ */
package reasoning_web.logical;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSConstants;
import smart_gs.GSVersion;
import smart_gs.logical.URICreator;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.logical.GSResourcePointer;

public class Connection implements RWElement,URIBearer{
	
	public static final int LOOP = 0;
	public static final int SOURCE = 1;
	public static final int TARGET = 2;

	protected ExplanatoryNote expNote;
	protected GSResourcePointer source;
	protected GSResourcePointer target;
	protected String name = new String();
	protected String uri;
	protected String originalURI;
	protected String oldVersionURI;
	
	protected String version;
	
	protected Connection(GSResourcePointer source,GSResourcePointer target,
			ExplanatoryNote note,
			String uri, String originalURI, String version) {
		this.source = source;
		this.target = target;
		this.target.addSource(source);
		this.target.addConnection(this);
		this.source.addTarget(target);
		if (!this.source.equals(this.target)) source.addConnection(this);
		this.expNote = note;
		this.setURIs(uri, originalURI);
		if (originalURI.equals("")) {
			note.appendContainer(this);
		}
		this.version = version;
	}
	protected Connection(GSResourcePointer source,GSResourcePointer target,
			ExplanatoryNote note) {
		this.source = source;
		this.target = target;
		this.target.addSource(source);
		this.target.addConnection(this);
		this.source.addTarget(target);
		if (!this.source.equals(this.target)) source.addConnection(this);
		this.expNote = note;
		this.initializeURIs();
		this.version = GSVersion.getVersion();
		note.appendContainer(this);
	}

	public void setName(String name){
		this.name = name;
	}
	public String getName(){
		return this.name;
	}
	public ExplanatoryNote getExplanatoryNote(){
		return this.expNote;
	}
	public GSResourcePointer getSourcePointer(){
		return source;
	}
	public GSResourcePointer getTargetPointer() {
		return target;
	}

	public int typeOfPointerInConnection(ResourcePointer pointer){
		boolean is_source, is_target;
		is_source = pointer.equals(this.source);
		is_target = pointer.equals(this.target);
		
		if(is_source && is_target){
			return LOOP;
		}else if(is_source){
			return SOURCE;
		} else if(is_target){
			return TARGET;
		} else {
			System.out.println("Error in typeOfPointerInConnection");
			return -1;
		}
	}
	
	public String getSource() throws NotMarkupException {
		throw new NotMarkupException();
	}
	
	public void setURI(String uri) {
		this.uri = uri;
	}
	public String getURI() {
		return this.uri;
	}
	public String getURIWithoutExtension() {
		return this.uri.substring(GSConstants.URI_HEADER.length());
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	public String getTypeString() {
		return URICreator.CONNECTION;
	}
	
	public RWElement getSourceRWElement() {
		return this.getSourcePointer().getGSResource();
	}
	public RWElement getTargetRWElement() {
		return this.getTargetPointer().getGSResource();
	}
	public String getOriginalURI() {
		return this.originalURI;
	}
	@Override
	public void setOriginalURI(String originalURI) {
		this.originalURI = originalURI;
	}
	@Override
	public void setURIs(String uri, String originalURI) {
		URICreator.setURIs(this, uri, originalURI);
	}
	@Override
	public void initializeURIs() {
		this.originalURI = URICreator.createURI(this);
		this.uri = this.originalURI;
	}
	@Override
	public String getVersion() {
		return this.version;
	}
	@Override
	public void setVersion(String version) {
		this.version = version;
	}
	@Override
	public String getOldVersionURI() {
		return this.oldVersionURI;
	}
	@Override
	public void setOldVersionURI(String oldVersionURI) {
		this.oldVersionURI = oldVersionURI;
	}
}
