/* $Id: UndoAction.java 1074 2016-02-29 02:31:14Z ohura $ */
package com.hexidec.ekit.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.CannotUndoException;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.UndoSet;

import smart_gs.smleditor.swingui.GSEditorTextPane;

public class UndoAction extends AbstractAction{
	protected GSHTMLEditor gsHTMLEditor;
	protected boolean keyevent = true;
	public UndoAction(GSHTMLEditor gsHTMLEditor){
		super("Undo*");
		setEnabled(false);
		this.gsHTMLEditor = gsHTMLEditor;
	}
	public void setKeyEvent(boolean keyevent){
		this.keyevent = keyevent;
	}
	public void undo(){
		if(keyevent){
			actionPerformed(null);
		}
	}
	public void actionPerformed(ActionEvent e){
		try{
			this.gsHTMLEditor.stopDocumentListener();
			UndoSet undoSet = this.gsHTMLEditor.getUndoManager().undo();
			if(undoSet != null){
				/*
				int point = gsHTMLEditor.getCaretPosition();
				System.out.println("1:"+point);
				*/
				gsHTMLEditor.setSource(undoSet.getSource());
				gsHTMLEditor.setCaretPosition(undoSet.getPosition()+1);
				((GSEditorTextPane) gsHTMLEditor).save();
				//gsHTMLEditor.setCaretPosition(source.length());
				/*
				int point2 = gsHTMLEditor.getCaretPosition();
				System.out.println("2:"+point2);
				*/
				
			}
			this.gsHTMLEditor.startDocumentListener();
		}catch(CannotUndoException ex){
//			ex.printStackTrace();
		}
	}
    public boolean isEnabled() {
        return true;
    }
}