/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jp.ac.nii.hcp.shared.validation.NumberOf;
import jp.ac.nii.hcp.shared.validation.NumberOfAspect;
import jp.ac.nii.hcp.shared.validation.Required;
import jp.ac.nii.hcp.shared.validation.RequiredAspect;
import jp.ac.nii.hcp.shared.validation.Size;
import jp.ac.nii.hcp.shared.validation.SizeAspect;
import jp.ac.nii.hcp.shared.validation.StringOf;
import jp.ac.nii.hcp.shared.validation.StringOfAspect;
import jp.ac.nii.hcp.shared.validation.Validate;
import jp.ac.nii.hcp.shared.validation.ValidateAspect;
import jp.ac.nii.hcp.shared.validation.ValidationAspect;

public class Validator {
    public static Result[] validateArgs(Method method, Object[] args) throws Throwable {
        Annotation[][] methodAnnotations = method.getParameterAnnotations();
        int argc = methodAnnotations.length;
        Result[] results = new Result[argc];
        int i = 0;
        while (i < argc) {
            Annotation[] argAnnotations = methodAnnotations[i];
            results[i] = Validator.validateAnnotatedValue(args[i], argAnnotations);
            ++i;
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    public static Result validateAnnotatedValue(Object value, Annotation[] annotations) {
        void var4_5;
        int annc = annotations.length;
        ArrayList aspects = new ArrayList();
        boolean bl = false;
        while (var4_5 < annc) {
            ValidationAspect<?> tmpAspect = Validator.getAspect(annotations[var4_5]);
            if (tmpAspect != null) {
                aspects.add(tmpAspect);
            }
            ++var4_5;
        }
        for (ValidationAspect validationAspect : aspects) {
            Result result = Validator.iterableValidate(value, validationAspect);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static ValidationAspect<?> getAspect(Annotation ann) {
        if (ann instanceof Required) {
            return new RequiredAspect();
        }
        if (ann instanceof Size) {
            return new SizeAspect((Size)ann);
        }
        if (ann instanceof StringOf) {
            return new StringOfAspect((StringOf)ann);
        }
        if (ann instanceof NumberOf) {
            return new NumberOfAspect((NumberOf)ann);
        }
        if (ann instanceof Validate) {
            return new ValidateAspect();
        }
        return null;
    }

    private static <T> Result iterableValidate(Object arg, ValidationAspect<T> aspect) {
        if (arg == null) {
            return aspect.checkNull() ? Validator.validate(arg, aspect) : null;
        }
        if (arg.getClass().isArray() && !aspect.checkSet()) {
            int length = Array.getLength(arg);
            Result result = null;
            int i = 0;
            while (i < length) {
                result = Validator.validate(Array.get(arg, i), aspect);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        } else if (arg instanceof Iterable && !aspect.checkSet()) {
            Iterable it = (Iterable)Iterable.class.cast(arg);
            Result result = null;
            for (Object obj : it) {
                result = Validator.validate(obj, aspect);
                if (result == null) continue;
                return result;
            }
        } else {
            return Validator.validate(arg, aspect);
        }
        return null;
    }

    private static <T> Result validate(Object arg, ValidationAspect<T> aspect) {
        Class<?> type = aspect.getTargetType();
        if (arg == null) {
            return aspect._validate(arg);
        }
        if (type.isAssignableFrom(arg.getClass())) {
            return aspect._validate(arg);
        }
        return null;
    }

    public static class Result {
        public Class<?> type;
        public String method;
        public Object[] args;

        public Result(Class<?> type, String method, Object[] args) {
            this.type = type;
            this.method = method;
            this.args = args;
        }
    }
}

