/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.service.test;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.sql.SQLException;
import jp.ac.nii.hcp.shared.environment.ConnectionFactory;
import jp.ac.nii.hcp.shared.module.TokenProcessor;
import jp.ac.nii.hcp.shared.service.Connect;
import jp.ac.nii.hcp.shared.service.ConnectionService;
import jp.ac.nii.hcp.shared.service.ServiceAPI;
import jp.ac.nii.hcp.shared.service.ServiceSession;
import jp.ac.nii.hcp.shared.service.Transactional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceTest {
    private static ReferenceQueue<ServiceSession> queue = new ReferenceQueue();
    private static PhantomReference<ServiceSession> ref = null;
    private static Log log = LogFactory.getLog(ServiceTest.class);

    public static void main(String[] args) throws Exception {
        ConnectionFactory.setupConnection("jdbc:mysql://localhost:3306/hcp_repository", "hcp", "hcp");
        Class.forName("jp.ac.nii.hcp.shared.service.test.A");
        Class.forName("jp.ac.nii.hcp.shared.service.test.A$B");
    }

    private static void doSession() throws SQLException {
        ServiceSession session = ServiceSession.open();
        ref = new PhantomReference<ServiceSession>(session, queue);
        ReferenceQueue wQueue = new ReferenceQueue();
        log.debug((Object)"Create default service");
        TestAPI service = session.createService(TestAPI.class, TestService.class);
        service.execute();
        log.debug((Object)"Create transactional service");
        service = session.createService(TestAPI.class, TestServiceT.class);
        service.execute();
        log.debug((Object)"Create service with transactional method");
        service = session.createService(TestAPI.class, TestServiceMT.class);
        service.execute();
        log.debug((Object)"Create service without connection");
        service = session.createService(TestAPI.class, TestServiceNC.class);
        service.execute();
        session = null;
        service = null;
        System.out.println("Phantom in Queue ? : " + ref.isEnqueued());
        log.debug((Object)("Phantom in Queue ? : " + ref.isEnqueued()));
    }

    public static interface TestAPI
    extends ServiceAPI {
        public void execute() throws SQLException;
    }

    public static class TestService
    extends ConnectionService
    implements TestAPI {
        @Override
        public void execute() throws SQLException {
            TokenProcessor p = this.getProcessor(TokenProcessor.class, new Object[0]);
            System.out.println("TestService.");
        }
    }

    public static class TestServiceMT
    extends ConnectionService
    implements TestAPI {
        @Override
        @Transactional
        public void execute() throws SQLException {
            TokenProcessor p = this.getProcessor(TokenProcessor.class, new Object[0]);
            this.ng();
            System.out.println("TestService with transactional method.");
        }
    }

    @Connect(value=false)
    public static class TestServiceNC
    extends ConnectionService
    implements TestAPI {
        @Override
        public void execute() throws SQLException {
            TokenProcessor p = this.getProcessor(TokenProcessor.class, new Object[0]);
            System.out.println("TestService without connection.");
        }
    }

    @Transactional
    public static class TestServiceT
    extends ConnectionService
    implements TestAPI {
        @Override
        public void execute() throws SQLException {
            TokenProcessor p = this.getProcessor(TokenProcessor.class, new Object[0]);
            System.out.println("TestService with transaction.");
        }
    }
}

