/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.workspace;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.ac.nii.hcp.client.workspace.AbstractWorkspace;

public class ImageSpace
extends AbstractWorkspace {
    protected ImageSpace(File root) {
        super(root);
    }

    public boolean exists(String path) {
        File imageFile = this.search(path);
        return imageFile != null;
    }

    public File loadImage(String path) {
        return this.search(path);
    }

    public void saveImage(String path, InputStream stream) throws IOException {
        File imageFile = new File(this.root, path);
        File imageDir = imageFile.getParentFile();
        if (!imageDir.exists()) {
            imageDir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(imageFile);
        int bytes = 0;
        byte[] buf = new byte[4096];
        while ((bytes = stream.read(buf)) >= 0) {
            out.write(buf, 0, bytes);
        }
        out.close();
    }

    public void deleteImage(String path) {
        File imageFile = this.search(path);
        if (imageFile != null) {
            imageFile.delete();
        }
    }

    public void clear() {
        this.clearDirectory(this.root);
    }

    private File search(String path) {
        File withoutExt = new File(this.root, path);
        if (withoutExt.exists()) {
            return withoutExt;
        }
        File candidateDir = withoutExt.getParentFile();
        if (candidateDir != null && candidateDir.isDirectory()) {
            File[] candidates = candidateDir.listFiles();
            String withoutExtPath = String.valueOf(withoutExt.getAbsolutePath()) + ".";
            File[] fileArray = candidates;
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                File candidate = fileArray[n2];
                if (candidate.getAbsolutePath().startsWith(withoutExtPath)) {
                    return candidate;
                }
                ++n2;
            }
        }
        return null;
    }
}

