/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.net;

import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import jp.ac.nii.hcp.client.net.RepositoryConnection;
import jp.ac.nii.hcp.client.net.URLHolder;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.ClientConfiguration;
import jp.ac.nii.hcp.client.shared.ClientStatus;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPMixedWrapper;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;
import jp.ac.nii.hcp.shared.model.ProjectCommitWrapper;

public class ProjectContentClient {
    private String name;
    private RepositoryConnection client;
    private ClientConfiguration config;

    public ProjectContentClient(String name, RepositoryConnection client, ClientConfiguration config) {
        this.name = name;
        this.client = client;
        this.config = config;
    }

    public HCPMaterial fetchMaterial(String id) throws IOException, UnauthorizedException, HCPClientException {
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("material").append(id, true).toUrl();
        HCPMixedWrapper wrapper = this.fetchContent(url, HCPMixedWrapper.class);
        return wrapper != null ? (HCPMaterial)wrapper.getHCPElement(HCPMaterial.class) : null;
    }

    public HCPDocument fetchDocument(String id, int revision) throws IOException, UnauthorizedException, HCPClientException {
        HCPMixedWrapper wrapper;
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("document").append(id, true).toUrl();
        WebResource resource = this.client.resource(url);
        if (revision > 0) {
            resource = resource.queryParam("revision", String.valueOf(revision));
        }
        return (wrapper = this.fetchContent(resource, HCPMixedWrapper.class)) != null ? (HCPDocument)wrapper.getHCPElement(HCPDocument.class) : null;
    }

    public HCPAttachment fetchAttachment(String id) throws IOException, UnauthorizedException, HCPClientException {
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("attachment").append(id, true).toUrl();
        HCPMixedWrapper wrapper = this.fetchContent(url, HCPMixedWrapper.class);
        return wrapper != null ? (HCPAttachment)wrapper.getHCPElement(HCPAttachment.class) : null;
    }

    public List<HCPMaterial> searchMaterials() throws IOException, UnauthorizedException, HCPClientException {
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("material").toUrl();
        HCPMixedWrapper list = this.fetchContent(url, HCPMixedWrapper.class);
        return list != null ? list.getHCPElements(HCPMaterial.class) : new ArrayList();
    }

    public List<HCPDocument> searchDocuments() throws IOException, UnauthorizedException, HCPClientException {
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("document").toUrl();
        HCPMixedWrapper list = this.fetchContent(url, HCPMixedWrapper.class);
        return list != null ? list.getHCPElements(HCPDocument.class) : new ArrayList();
    }

    public List<HCPAttachment> searchAttachments() throws IOException, UnauthorizedException, HCPClientException {
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("attachment").toUrl();
        HCPMixedWrapper list = this.fetchContent(url, HCPMixedWrapper.class);
        return list != null ? list.getHCPElements(HCPAttachment.class) : new ArrayList();
    }

    public ProjectCommitWrapper addMaterial(HCPMaterial material) throws IOException, UnauthorizedException, HCPClientException {
        return this.commitContent(true, material, HCPMaterial.class);
    }

    public ProjectCommitWrapper addDocument(HCPDocument document) throws IOException, UnauthorizedException, HCPClientException {
        return this.commitContent(true, document, HCPDocument.class);
    }

    public ProjectCommitWrapper addTextAttachment(HCPAttachment attachment) throws IOException, UnauthorizedException, HCPClientException {
        return this.commitContent(true, attachment, HCPAttachment.class);
    }

    public ProjectCommitWrapper addFileAttachment(HCPAttachment attachment, InputStream entity) throws IOException, UnauthorizedException, HCPClientException {
        ArrayList<InputStream> entities = new ArrayList<InputStream>();
        entities.add(entity);
        return this.commitContent(true, attachment, HCPAttachment.class, entities);
    }

    public ProjectCommitWrapper commitMaterial(HCPMaterial material) throws IOException, UnauthorizedException, HCPClientException {
        return this.commitContent(false, material, HCPMaterial.class);
    }

    public ProjectCommitWrapper commitDocument(HCPDocument document) throws IOException, UnauthorizedException, HCPClientException {
        return this.commitContent(false, document, HCPDocument.class);
    }

    public ProjectCommitWrapper commitAttachment(HCPAttachment attachment) throws IOException, UnauthorizedException, HCPClientException {
        return this.commitContent(false, attachment, HCPAttachment.class);
    }

    public ProjectCommitWrapper deleteMaterial(String id) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("material").append(id, true).toUrl();
        return this.client.request(url, "DELETE", null, null, ProjectCommitWrapper.class);
    }

    public ProjectCommitWrapper deleteDocument(String id) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("document").append(id, true).toUrl();
        return this.client.request(url, "DELETE", null, null, ProjectCommitWrapper.class);
    }

    public ProjectCommitWrapper deleteAttachment(String id) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("attachment").append(id, true).toUrl();
        return this.client.request(url, "DELETE", null, null, ProjectCommitWrapper.class);
    }

    public InputStream downloadFileAttachment(HCPAttachment attachment) throws IOException, UnauthorizedException, HCPClientException {
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("attachment").append(attachment.id, true).append("entity").toUrl();
        try {
            InputStream data = this.client.request(url, "GET", MediaType.APPLICATION_OCTET_STREAM_TYPE, MediaType.TEXT_HTML_TYPE, InputStream.class);
            return data;
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatus() == 404) {
                return null;
            }
            throw new HCPClientException(ClientStatus.HTTP_ERROR, "Operation is aborted because HTTP error code is received.", e);
        }
    }

    public void uploadFileAttachment(HCPAttachment attachment, InputStream entity) throws IOException, UnauthorizedException, HCPClientException {
        String url = this.config.repositoryAPIURL().append("project").append(this.name, true).append("attachment").append(attachment.id, true).append("entity").toUrl();
        try {
            this.client.request(url, "PUT", null, MediaType.APPLICATION_OCTET_STREAM_TYPE, null, (Object)entity);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatus() == 404) {
                throw new HCPClientException(ClientStatus.CONTENT_ALREADY_DELETED, String.format("File attachment '%s' does not exist in repository.", attachment.id), e);
            }
            throw new HCPClientException(ClientStatus.HTTP_ERROR, "Operation is aborted because HTTP error code is received.", e);
        }
    }

    private <T> T fetchContent(String url, Class<T> type) throws IOException, UnauthorizedException, HCPClientException {
        return this.fetchContent(this.client.resource(url), type);
    }

    private <T> T fetchContent(WebResource resource, Class<T> type) throws IOException, UnauthorizedException, HCPClientException {
        try {
            return this.client.request(resource, "GET", null, MediaType.APPLICATION_XML_TYPE, type);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatus() == 404) {
                return null;
            }
            throw new HCPClientException(ClientStatus.HTTP_ERROR, "Operation is aborted because HTTP error code is received.", e);
        }
    }

    public <T extends HCPProjectContent> ProjectCommitWrapper commitContent(boolean creation, T content, Class<T> type) throws IOException, UnauthorizedException, HCPClientException {
        return this.commitContent(creation, content, type, null);
    }

    public <T extends HCPProjectContent> ProjectCommitWrapper commitContent(boolean creation, T content, Class<T> type, List<InputStream> entities) throws IOException, UnauthorizedException, HCPClientException {
        URLHolder.Builder urlBuilder = this.config.repositoryAPIURL().append("project").append(this.name, true);
        if (type == HCPMaterial.class) {
            urlBuilder.append("material");
        } else if (type == HCPDocument.class) {
            urlBuilder.append("document");
        } else if (type == HCPAttachment.class) {
            urlBuilder.append("attachment");
        }
        if (!creation) {
            urlBuilder.append(content.id, true);
        }
        String url = urlBuilder.toUrl();
        ProjectCommitWrapper wrapper = new ProjectCommitWrapper();
        if (creation) {
            wrapper.difference.added.add(content);
        } else {
            wrapper.difference.modified.add(content);
        }
        FormDataMultiPart mp = null;
        if (entities != null && entities.size() > 0) {
            mp = new FormDataMultiPart();
            mp.field("content", (Object)wrapper, MediaType.APPLICATION_XML_TYPE);
            int index = 1;
            for (InputStream entity : entities) {
                mp.field("entity" + index++, (Object)entity, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            }
        }
        String method = creation ? "POST" : "PUT";
        try {
            if (mp == null) {
                return this.client.request(url, method, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE, ProjectCommitWrapper.class, (Object)wrapper);
            }
            return this.client.request(url, method, MediaType.APPLICATION_XML_TYPE, MediaType.MULTIPART_FORM_DATA_TYPE, ProjectCommitWrapper.class, (Object)mp);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatus() == 409) {
                return null;
            }
            if (e.getResponse().getStatus() == 404) {
                throw new HCPClientException(ClientStatus.CONTENT_ALREADY_DELETED, String.format("Content '%s' does not exist in repository.", content.id), e);
            }
            throw new HCPClientException(ClientStatus.HTTP_ERROR, "Operation is aborted because HTTP error code is received.", e);
        }
    }
}

