/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.net;

import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.MediaType;
import jp.ac.nii.hcp.client.net.AuthenticationCache;
import jp.ac.nii.hcp.client.net.RepositoryConnection;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.ClientConfiguration;
import jp.ac.nii.hcp.shared.model.HCPMixedWrapper;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;
import jp.ac.nii.hcp.shared.model.OAuthToken;

public class AuthenticationClient {
    private RepositoryConnection connection;
    private ClientConfiguration config;

    public AuthenticationClient(RepositoryConnection connection, ClientConfiguration config) {
        this.connection = connection;
        this.config = config;
    }

    public AuthenticationCache login(String email, String password) throws IOException {
        AuthenticationCache auth = null;
        try {
            auth = this.authenticate(email, password);
        }
        catch (UnauthorizedException e) {
            return null;
        }
        return auth;
    }

    public void logout() throws IOException, UnauthorizedException {
        String url = this.config.logoutURL();
        this.connection.request(url, "DELETE", null, null, null);
    }

    public static AuthenticationCache connect(String email, String password, RepositoryConnection connection, ClientConfiguration config) throws IOException {
        AuthenticationClient client = new AuthenticationClient(connection, config);
        return client.login(email, password);
    }

    public AuthenticationCache checkToken(OAuthToken token) throws IOException {
        String url = this.config.authCheckURL();
        this.connection.setAuthentication(token, this.config.signatureMethod(), this.config.consumerKey(), this.config.consumerSecret());
        try {
            HCPMixedWrapper wrapper = this.connection.request(url, "GET", MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_XML_TYPE, HCPMixedWrapper.class);
            return new AuthenticationCache(token, (HCPUser)wrapper.getHCPElement(HCPUser.class), (HCPUserGroup)wrapper.getHCPElement(HCPUserGroup.class));
        }
        catch (UnauthorizedException e) {
            return null;
        }
    }

    public List<HCPUserGroup> getGroups(AuthenticationCache auth) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("user").append(auth.user.id).append("group").toUrl();
        HCPMixedWrapper wrapper = this.connection.request(url, "GET", MediaType.APPLICATION_XML_TYPE, null, HCPMixedWrapper.class);
        return wrapper.getHCPElements(HCPUserGroup.class);
    }

    public List<HCPUser> getUsers(String groupId) throws IOException, UnauthorizedException {
        String url = this.config.repositoryAPIURL().append("group").append(groupId).append("user").toUrl();
        HCPMixedWrapper wrapper = this.connection.request(url, "GET", MediaType.APPLICATION_XML_TYPE, null, HCPMixedWrapper.class);
        return wrapper.getHCPElements(HCPUser.class);
    }

    private AuthenticationCache authenticate(String email, String password) throws IOException, UnauthorizedException {
        this.connection.clearAuthentication();
        String url = this.config.requestTokenRequestURL();
        this.connection.setAuthentication(null, this.config.signatureMethod(), this.config.consumerKey(), this.config.consumerSecret());
        OAuthToken requestToken = this.connection.request(url, "POST", MediaType.TEXT_PLAIN_TYPE, MediaType.APPLICATION_FORM_URLENCODED_TYPE, OAuthToken.class);
        String secret = requestToken.secret;
        this.connection.clearAuthentication();
        url = this.config.requestTokenAuthorizeURL();
        WebResource resource = this.connection.resource(url).queryParam("email", email).queryParam("password", password).queryParam("token", requestToken.token);
        requestToken = this.connection.request(resource, "POST", MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_PLAIN_TYPE, OAuthToken.class);
        requestToken.secret = secret;
        this.connection.setAuthentication(requestToken, this.config.signatureMethod(), this.config.consumerKey(), this.config.consumerSecret());
        url = this.config.accessTokenRequestURL();
        OAuthToken accessToken = this.connection.request(url, "POST", MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_PLAIN_TYPE, OAuthToken.class);
        return this.checkToken(accessToken);
    }
}

