/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.module;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import jp.ac.nii.hcp.client.module.Constants;
import jp.ac.nii.hcp.client.module.ModelUtility;
import jp.ac.nii.hcp.client.module.SqliteProcessor;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;
import jp.ac.nii.hcp.shared.model.ProjectDifference;

public class ProjectProcessor
extends SqliteProcessor {
    public ProjectProcessor(Connection db) {
        super(db);
    }

    public HCPProject importProject(HCPProject project, boolean original) throws SQLException {
        HCPProjectContent.Record record;
        this.doUpdate("DELETE FROM attachment", new Object[0]);
        this.doUpdate("DELETE FROM document", new Object[0]);
        this.doUpdate("DELETE FROM material", new Object[0]);
        this.doUpdate("DELETE FROM prj_content", new Object[0]);
        this.doUpdate("DELETE FROM project", new Object[0]);
        HCPProject target = null;
        if (original) {
            target = project.clone();
            ModelUtility.toOriginal(target);
        } else {
            target = project;
        }
        String sql = "INSERT INTO project (name, revision, created, modified) VALUES (?, ?, ?, ?)";
        this.doUpdate(sql, new Object[]{target.name, target.revision, target.created, target.modified});
        PreparedStatement contentStmt = this.prepareStatement("INSERT INTO prj_content (sequence, id, type, revision, added_rev, created, created_by, creator_ln, creator_fn, modified, modified_by, modifier_ln, modifier_fn) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[0]);
        PreparedStatement stmt = this.prepareStatement("INSERT INTO material (id, image_path, description) VALUES (?, ?, ?)", new Object[0]);
        for (HCPMaterial material : target.materials) {
            this.doUpdate(stmt, new Object[]{material.id, material.imagePath, material.description});
            record = material.record;
            this.doUpdate(contentStmt, new Object[]{material.sequence, material.id, Constants.PROJECT_CTYPE.getValue((Object)HCPProjectContent.ContentType.MATERIAL), record.revision, record.added, record.created, record.createdBy.id, record.createdBy.lastName, record.createdBy.firstName, record.modified, record.modifiedBy.id, record.modifiedBy.lastName, record.modifiedBy.firstName});
        }
        stmt.close();
        stmt = this.prepareStatement("INSERT INTO document (id, source, description) VALUES (?, ?, ?)", new Object[0]);
        for (HCPDocument document : target.documents) {
            this.doUpdate(stmt, new Object[]{document.id, document.source, document.description});
            record = document.record;
            this.doUpdate(contentStmt, new Object[]{document.sequence, document.id, Constants.PROJECT_CTYPE.getValue((Object)HCPProjectContent.ContentType.DOCUMENT), record.revision, record.added, record.created, record.createdBy.id, record.createdBy.lastName, record.createdBy.firstName, record.modified, record.modifiedBy.id, record.modifiedBy.lastName, record.modifiedBy.firstName});
        }
        stmt.close();
        stmt = this.prepareStatement("INSERT INTO attachment (id, content_type, file_path, source, description) VALUES (?, ?, ?, ?, ?)", new Object[0]);
        for (HCPAttachment attachment : target.attachments) {
            this.doUpdate(stmt, new Object[]{attachment.id, attachment.contentType, attachment.filePath, attachment.source, attachment.description});
            record = attachment.record;
            this.doUpdate(contentStmt, new Object[]{attachment.sequence, attachment.id, Constants.PROJECT_CTYPE.getValue((Object)HCPProjectContent.ContentType.ATTACHMENT), record.revision, record.added, record.created, record.createdBy.id, record.createdBy.lastName, record.createdBy.firstName, record.modified, record.modifiedBy.id, record.modifiedBy.lastName, record.modifiedBy.firstName});
        }
        stmt.close();
        this.prepareEdition();
        return target;
    }

    public HCPProject get() throws SQLException {
        ResultSet rs = this.doQuery("SELECT * FROM project", new Object[0]);
        if (rs.next()) {
            HCPProject project = new HCPProject(rs.getString("name"), rs.getInt("revision"), null, null, (Date)rs.getTimestamp("created"), (Date)rs.getTimestamp("modified"));
            return project;
        }
        return null;
    }

    public void apply(HCPProject project) throws SQLException {
        this.doUpdate("UPDATE project SET revision = ?, created = ?, modified = ?", new Object[]{project.revision, project.created, project.modified});
    }

    public void apply(ProjectDifference diff) throws SQLException {
        this.doUpdate("UPDATE project SET revision = ?, modified = ?", new Object[]{diff.revision, diff.updated});
    }

    private void prepareEdition() throws SQLException {
        this.doUpdate("DELETE FROM edit_material", new Object[0]);
        this.doUpdate("DELETE FROM edit_document", new Object[0]);
        this.doUpdate("DELETE FROM edit_attachment", new Object[0]);
        this.doUpdate("INSERT INTO edit_material SELECT * FROM material", new Object[0]);
        this.doUpdate("INSERT INTO edit_document SELECT * FROM document", new Object[0]);
        this.doUpdate("INSERT INTO edit_attachment SELECT * FROM attachment", new Object[0]);
    }

    public void commitEdition() throws SQLException {
        this.doUpdate("DELETE FROM material", new Object[0]);
        this.doUpdate("DELETE FROM document", new Object[0]);
        this.doUpdate("DELETE FROM attachment", new Object[0]);
        this.doUpdate("INSERT INTO material SELECT * FROM edit_material", new Object[0]);
        this.doUpdate("INSERT INTO document SELECT * FROM edit_document", new Object[0]);
        this.doUpdate("INSERT INTO attachment SELECT * FROM edit_attachment", new Object[0]);
    }

    public void createSchema() throws SQLException {
        this.doUpdate("DROP TABLE IF EXISTS attachment", new Object[0]);
        this.doUpdate("DROP TABLE IF EXISTS document", new Object[0]);
        this.doUpdate("DROP TABLE IF EXISTS material", new Object[0]);
        this.doUpdate("DROP TABLE IF EXISTS prj_content", new Object[0]);
        this.doUpdate("DROP TABLE IF EXISTS project", new Object[0]);
        this.doUpdate("CREATE TABLE `project` (    name TEXT NOT NULL,    revision INTEGER NOT NULL,    created TEXT,    modified TEXT)", new Object[0]);
        this.doUpdate("CREATE TABLE `prj_content` (    sequence INTEGER NOT NULL,    id TEXT NOT NULL,    type TEXT NOT NULL,    revision INTEGER NOT NULL,    added_rev INTEGER NOT NULL,    created TEXT,    created_by TEXT,    creator_ln TEXT,    creator_fn TEXT,    modified TEXT,    modified_by TEXT,    modifier_ln TEXT,    modifier_fn TEXT)", new Object[0]);
        this.doUpdate("CREATE TABLE `material` (    id TEXT NOT NULL,    image_path TEXT NOT NULL,    description TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '')", new Object[0]);
        this.doUpdate("CREATE TABLE `edit_material` (    id TEXT NOT NULL,    image_path TEXT NOT NULL,    description TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '')", new Object[0]);
        this.doUpdate("CREATE TABLE `document` (    id TEXT NOT NULL,    source TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '',    description TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '')", new Object[0]);
        this.doUpdate("CREATE TABLE `edit_document` (    id TEXT NOT NULL,    source TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '',    description TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '')", new Object[0]);
        this.doUpdate("CREATE TABLE `attachment` (    id TEXT NOT NULL,    content_type TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '*/*',    file_path TEXT,    source TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '',    description TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '')", new Object[0]);
        this.doUpdate("CREATE TABLE `edit_attachment` (    id TEXT NOT NULL,    content_type TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '*/*',    file_path TEXT,    source TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '',    description TEXT NOT NULL ON CONFLICT REPLACE DEFAULT '')", new Object[0]);
    }

    public void changeName(String name) throws SQLException {
        this.doUpdate("UPDATE project SET name = ?", new Object[]{name});
    }
}

