/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.core;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import jp.ac.nii.hcp.client.module.ProjectContentProcessor;
import jp.ac.nii.hcp.client.shared.ClientStatus;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.client.workspace.ImageSpace;
import jp.ac.nii.hcp.client.workspace.ProjectSpace;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;
import jp.ac.nii.hcp.shared.module.BaseProcessor;

public class ProjectEditor {
    private ProjectSpace space;
    private ImageSpace imageSpace;
    private Connection db;

    protected ProjectEditor(ProjectSpace space, ImageSpace imageSpace) {
        this.space = space;
        this.imageSpace = imageSpace;
    }

    public void open() throws HCPClientException {
        try {
            this.db = this.space.getConnection();
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error", e);
        }
    }

    public void close() {
        this.space.dispose();
    }

    public String readDocument(String id) throws HCPClientException {
        HCPDocument document = this.getDocument(id);
        return document != null ? document.source : null;
    }

    public String readTextAttachment(String id) throws HCPClientException {
        HCPAttachment attachment = this.getAttachment(id);
        return attachment != null ? attachment.source : null;
    }

    public File loadMaterial(String id) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            HCPMaterial material = processor.getMaterial(id);
            if (material != null && this.imageSpace.exists(material.imagePath)) {
                return this.imageSpace.loadImage(material.imagePath);
            }
            return null;
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public File loadFileAttachment(String id) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            HCPAttachment attachment = processor.getAttachment(id);
            if (attachment != null && this.space.hasAttachmentFile(attachment)) {
                return this.space.getAttachmentFile(attachment);
            }
            return null;
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public HCPMaterial getMaterial(String id) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            return processor.getMaterial(id);
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public HCPDocument getDocument(String id) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            return processor.getDocument(id);
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public HCPAttachment getAttachment(String id) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            return processor.getAttachment(id);
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public List<HCPMaterial> getMaterials() throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            return processor.getMaterials();
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public List<HCPDocument> getDocuments() throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            return processor.getDocuments();
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public List<HCPAttachment> getAttachments() throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            return processor.getAttachments();
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void addMaterial(String id, String imagePath, String description) throws HCPClientException {
        if (!HCPProjectContent.validateId((String)id)) {
            throw new HCPClientException(ClientStatus.CONTENT_ID_INVALID, String.format("'%s' is unavailable as content ID.", id), null);
        }
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            if (imagePath == null || !this.imageSpace.exists(imagePath)) {
                throw new HCPClientException(ClientStatus.IMAGE_NOT_FOUND, String.format("Image '%s' does not exist in workspace.", imagePath), null);
            }
            if (processor.exists(id)) {
                throw new HCPClientException(ClientStatus.ID_ALREADY_EXISTS, "Contents ID '" + id + "' is already used.", null);
            }
            processor.addMaterial(id, imagePath, description, 0, 0);
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void addDocument(String id, String source, String description) throws HCPClientException {
        if (!HCPProjectContent.validateId((String)id)) {
            throw new HCPClientException(ClientStatus.CONTENT_ID_INVALID, String.format("'%s' is unavailable as content ID.", id), null);
        }
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            if (processor.exists(id)) {
                throw new HCPClientException(ClientStatus.ID_ALREADY_EXISTS, "Contents ID '" + id + "' is already used.", null);
            }
            processor.addDocument(id, source, description, 0, 0);
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void addTextAttachment(String id, String source, String description) throws HCPClientException {
        if (!HCPProjectContent.validateId((String)id)) {
            throw new HCPClientException(ClientStatus.CONTENT_ID_INVALID, String.format("'%s' is unavailable as content ID.", id), null);
        }
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            if (processor.exists(id)) {
                throw new HCPClientException(ClientStatus.ID_ALREADY_EXISTS, "Contents ID '" + id + "' is already used.", null);
            }
            processor.addTextAttachment(id, source, description, 0, 0);
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void setDocument(String id, String source) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            if (!processor.exists(id, HCPProjectContent.ContentType.DOCUMENT)) {
                throw new HCPClientException(ClientStatus.CONTENT_NOT_FOUND, "Document '" + id + "' is not found.", null);
            }
            processor.setDocument(id, source);
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void setTextAttachment(String id, String source) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            if (processor.exists(id, HCPProjectContent.ContentType.ATTACHMENT)) {
                if (!processor.setTextAttachment(id, source)) {
                    this.rollback();
                    throw new HCPClientException(ClientStatus.UNMATCHED_ATTACHMENT_TYPE, "Attachment '" + id + "' is not text attachment data.", null);
                }
            } else {
                throw new HCPClientException(ClientStatus.CONTENT_NOT_FOUND, "Attachment '" + id + "' is not found.", null);
            }
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void setFileAttachment(String id, String contentType) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            if (processor.exists(id, HCPProjectContent.ContentType.ATTACHMENT)) {
                if (!processor.setFileAttachment(id, contentType)) {
                    this.rollback();
                    throw new HCPClientException(ClientStatus.UNMATCHED_ATTACHMENT_TYPE, "Attachment '" + id + "' is not file attachment data.", null);
                }
            } else {
                throw new HCPClientException(ClientStatus.CONTENT_NOT_FOUND, "Attachment '" + id + "' is not found.", null);
            }
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void removeMaterial(String id) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            processor.deleteMaterial(id);
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void removeDocument(String id) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            processor.deleteDocument(id);
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void removeAttachment(String id) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            processor.deleteAttachment(id);
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void setDescription(String id, String description) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            if (!processor.exists(id)) {
                throw new HCPClientException(ClientStatus.CONTENT_NOT_FOUND, "Contents '" + id + "' is not found.", null);
            }
            processor.setDescription(id, description);
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    public void revertContent(String id) throws HCPClientException {
        ProjectContentProcessor processor = this.getProcessor(ProjectContentProcessor.class);
        try {
            if (!processor.exists(id)) {
                throw new HCPClientException(ClientStatus.CONTENT_NOT_FOUND, "Contents '" + id + "' is not found.", null);
            }
            processor.revertContent(id);
            this.commit();
        }
        catch (SQLException e) {
            this.rollback();
            throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
        }
    }

    private <T extends BaseProcessor> T getProcessor(Class<T> type) {
        return (T)BaseProcessor.getProcessor(type, (Connection)this.db, (Object[])new Object[0]);
    }

    private void commit() throws SQLException {
        this.db.commit();
    }

    private void rollback() {
        try {
            this.db.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

