package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import org.apache.commons.io.FileUtils;

import smart_gs.logical.LineSegment;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.util.DSCFileMaker;



public class LineSegDscInformationAction implements ActionListener {
	private LineSegEditor editor;
	private Spread spread;
	
	public LineSegDscInformationAction(LineSegEditor parent) {
		this.editor = parent;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		this.spread = this.editor.getSpread();
		String information;
		File imageFile = spread.getImageFile();
		File dscFile = spread.getDscFile();
		File lineSegFile = spread.getLineSegFile();
		File dscLineSegFile = spread.getDscLineSegFile();
		String imageFileInfo;
		String dscFileInfo;
		String lineSegFileInfo;
		String dscLineSegFileInfo;
		DateFormat df1 = DateFormat.getDateTimeInstance(DateFormat.LONG,DateFormat.LONG);
		
		String title = imageFile.getName() + "\n";
		if (imageFile == null || !imageFile.exists()){
			imageFileInfo = "Image File: none\n";
			}
		else {
			imageFileInfo = String.format("Image File: Size %s; Last modefied %s\n",
					FileUtils.byteCountToDisplaySize(imageFile.length()),
					df1.format(new Date(imageFile.lastModified())));
		}
		if (lineSegFile == null || !lineSegFile.exists()){
			lineSegFileInfo = "Line Segment File: none\n";
			}
		else {
			lineSegFileInfo = String.format("Line Segment File for Image File: Size %s; Last modefied %s\n",
					FileUtils.byteCountToDisplaySize(lineSegFile.length()),
					df1.format(new Date(lineSegFile.lastModified())));
		}
		if (dscFile == null || !dscFile.exists()){
			dscFileInfo = "DSC File: none\n";
			}
		else {
			dscFileInfo = String.format("DSC File: Size %s; Last modefied %s\n",
					FileUtils.byteCountToDisplaySize(dscFile.length()),
					df1.format(new Date(dscFile.lastModified())));
		}
		if (dscLineSegFile == null || !dscLineSegFile.exists()){
			dscLineSegFileInfo = "Line Segment File for DSC file: none\n";
			}
		else {
			dscLineSegFileInfo = String.format("Line Segment File for DSC file: Size %s; Last modefied %s\n",
					FileUtils.byteCountToDisplaySize(dscLineSegFile.length()),
					df1.format(new Date(dscLineSegFile.lastModified())));
		}
		
		JOptionPane.showMessageDialog(editor, title + imageFileInfo + lineSegFileInfo + dscFileInfo + dscLineSegFileInfo);
	}

}
