/* $Id: WorkspaceWindowNorthPanel.java 654 2013-02-08 10:05:15Z ohura $ */
package smart_gs.swingui;

import java.awt.BorderLayout;

import javax.swing.JPanel;

import smart_gs.menu.GSMenuBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import sml_editor.logical.LineDirection;

/* this panel is used exclusively by WorkspaceWindow.
 * It is the same to the full editor except the default
 * menu bar, which includes save, load, etc.
 */
@SuppressWarnings("serial")
public class WorkspaceWindowNorthPanel extends JPanel{
	
	private ToolBarPanel toolBarPanel;
	private GSMenuBar gsMenuBar;
	
	public WorkspaceWindowNorthPanel(AbstractGSWindow parent){
		this.toolBarPanel = new ToolBarPanel(parent,true);
		this.setLayout(new BorderLayout());
		this.gsMenuBar = new GSMenuBar(parent,toolBarPanel.getGSEditorToolBar());
		this.add(this.gsMenuBar, BorderLayout.NORTH);
		this.add(toolBarPanel);
		this.validate();
	}
	
	public void setLineDirectionIcon(LineDirection direction) {
		this.toolBarPanel.setLineDirectionIcon(direction);
	}

	public 	HistoryToolBar getHistoryToolBar(){
		return this.toolBarPanel.getHistoryToolBar();
	}
	public 	MoveTreeToolBar getMoveTreeToolBar(){
		return this.toolBarPanel.getMoveTreeToolBar();
	}
	public 	ToolBarPanel getToolBarPanel(){
		return this.toolBarPanel;
	}
	public ImageToolBar getImageToolBar() {
		return this.toolBarPanel.getImageToolBar();
	}
	public GSMenuBar getGSMenuBar() {
		return this.gsMenuBar;
	}
}
