/* $Id: SpaceUtil.java 561 2012-09-05 04:28:55Z shayashi $ */
/*
GNU Lesser General Public License

FormatAction
Copyright (C) 2000 Howard Kistler

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

package smart_gs.spread_selection;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;

import javax.swing.JTextPane;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.component.SimpleInfoDialog;


/** Class for implementing HTML format actions
 * (NOTE : Does not toggle. User must use the "Clear Format" option to remove formatting correctly.)
 */
public class SpaceUtil 
{
	protected GSHTMLEditor parentEkit;
	public SpaceUtil(GSHTMLEditor ekit){
		parentEkit = ekit;
	}
	public void remove(int start,int end){
		String value = null;
		JTextPane parentTextPane = parentEkit.getTextPane();
		parentTextPane.setSelectionStart(start);
		parentTextPane.setSelectionEnd(end);
//			Element element = parentTextPane.getStyledDocument().getCharacterElement(pos);
//			SimpleAttributeSet sasText = new SimpleAttributeSet(element.getAttributes());
			SimpleAttributeSet sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
			Enumeration attribEntries1 = sasText.getAttributeNames();
			while(attribEntries1.hasMoreElements()){
				Object entryKey   = attribEntries1.nextElement();
				Object entryValue = sasText.getAttribute(entryKey);

				if(!entryKey.toString().equals("name")){
					sasText.removeAttribute(entryKey);
					parentTextPane.setCharacterAttributes(sasText, true);
				}
			}
		parentTextPane.setSelectionStart(end);
		parentTextPane.setSelectionEnd(end);
	}

}

