/* $Id: SelectRegionAction.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.keyboard.action;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.action.NextRegionAction;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.logical.Region;

public class SelectRegionAction implements KeyListener {
	SpreadCanvas canvas;
	
	public SelectRegionAction(SpreadCanvas canvas) {
		this.canvas = canvas;
	}

	public void keyPressed(KeyEvent arg0) {
		// TODO Auto-generated method stub

//		if(arg0.getModifiersEx()==InputEvent.ALT_DOWN_MASK){
//			System.out.println("alt+tab");
//		}
		char c = arg0.getKeyChar();
		System.out.println(c);
	}

	public void keyReleased(KeyEvent arg0) {
		// TODO Auto-generated method stub

	}

	public void keyTyped(KeyEvent e) {
		State state = this.canvas.getImageLabel().getState();
		SpreadCanvas canvas = this.canvas;
		if (state.getType() == State.UNISELECTED && e.getKeyCode() == KeyEvent.VK_TAB && e.isControlDown()) {
			Region region = ((UniSelectedState)state).getSelectedRegion();
			NextRegionAction nra = new NextRegionAction(region, canvas, state);
			nra.actionPerformed(e);
			e.consume();
		}
		
	}

}
