/* $Id: MarkerMode.java 623 2013-01-10 12:40:07Z ohura $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;


import smart_gs.debugprint.Debugprint;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
//import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.logical.Preference;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.region.MarkerRegion;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class MarkerMode extends DrawingModeAdapter{
	private Component startcomponent = null;
	private boolean out = false;
	private static Mode singleton = new MarkerMode();

	private Point2D start;
	private Point2D end;
	
	private Point2D tempStart;
	private Point2D tempEnd;
	
	private boolean temporary = false;
	
	public static Mode getInstance(){
		((MarkerMode)singleton).reset();
		return singleton;
	}
	
	private void reset() {
		startcomponent = null;
		out = false;
		start = null;
		end = null;		
	}
	
	@Override
	public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
		if (startcomponent == null) startcomponent = e.getComponent();
		if (e.getComponent() == startcomponent) {
			out = false;
			setCursor(canvas);
		} else {
			out = true;
		}
		setCursor(canvas);
	}
	
	@Override
	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		((MarkerMode)singleton).reset();
		startcomponent = e.getComponent();
		super.mousePressed(e, canvas);
		this.start = e.getPoint();
		this.tempStart = e.getOriginalPoint();
		setCursor(canvas);
	}
	@Override
	public void mouseDragged(GSMouseEvent e,SpreadCanvas canvas) {
		if(e.getComponent() != startcomponent){
			return ;
		}
		super.mouseDragged(e,canvas);
		this.end = e.getPoint();
		this.tempEnd = e.getOriginalPoint();
		setCursor(canvas);
	}
	
	@Override
	public void mouseMoved(GSMouseEvent e,SpreadCanvas canvas) {
		if (startcomponent == null) startcomponent = e.getComponent();
		if (e.getComponent() == startcomponent) {
			out = false;
		} else {
			out = true;
			return;
		}
		if(startcomponent != null && (e.getComponent() != startcomponent)){
			return ;
		}
		setCursor(canvas);
	}
	
	@Override
	public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
		super.mouseReleased(e, canvas);
		if(start == null || end == null){
			return ;
		}
		if (start.distance(end) > 8) {
			Region reg = new MarkerRegion(canvas.getSpread(),start,end);
			reg.setTemporary(this.isTemporary());
			canvas.addRegion(reg);
		}
		this.start = null;
		this.end = null;
		this.tempStart = null;
		this.tempEnd = null;
		DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
		new ImageToolBarSetModeByMouseEvent().setMode(e,ImageToolBar.modeNone);
		setCursor(canvas);
	}
	@Override
	public void paint(Graphics g,SpreadCanvas canvas) {
		if (out) return;
		if (startcomponent == null) return;
		if (canvas.getImageLabel() != startcomponent) return;
		if(this.tempStart == null || this.tempEnd == null){
			return;
		}
		ImageLabel imageLabel = canvas.getImageLabel();
		double ratio = imageLabel.getRatio();
		int canvasWidth = canvas.getWidth();
		int canvasHeight = canvas.getHeight();
		int iconHeight = imageLabel.getIcon().getIconHeight();
		int iconWidth = imageLabel.getIcon().getIconWidth();
		int scrollHeight = canvas.getHorizontalScrollBar().getHeight();
		int scrollWidth = canvas.getVerticalScrollBar().getWidth();
		double gapX = 0;
		double gapY = 0;
		if (iconWidth < canvasWidth) {
			gapX = (canvasWidth - scrollWidth - iconWidth) / 2.0;
		}
		if (iconHeight < canvasHeight) {
			gapY = (canvasHeight - scrollHeight - iconHeight) / 2.0;
		}
		Point2D start = new Point2D.Double(tempStart.getX() / ratio, tempStart.getY() / ratio);
		Point2D end = new Point2D.Double(tempEnd.getX() / ratio, tempEnd.getY() / ratio);
		MarkerView view = new MarkerView(start,end);
		int breadth = new Integer(Preference.getInstance().getMarkerBreadth());
		view.setBreadth(breadth);

		
		view.enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
//		if(this.start == null || this.end == null){
//			return;
//		}
//		double ratio = canvas.getImageLabel().getRatio();
//		new MarkerView(start,end).enlargedView(ratio).draw((Graphics2D)g);
	}
	
	@Override
	public boolean isTemporary() {
		return temporary;
	}
	@Override
	public void setTemporary(boolean sw) {
		temporary = sw;
	}
}
