/* $Id: SearchResultListPanel.java 654 2013-02-08 10:05:15Z ohura $ */
package smart_gs.dictionary.viewer;

import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.util.ImageCropper;
import sml_editor.logical.LineDirection;


@SuppressWarnings("serial")
public class SearchResultListPanel extends AbstractSearchResultPanel{
	
	private final int ROW = 9;
	private final int COLUMN = 7;
	
	private int WIDTH1 = 80;
	private int HEIGHT1 =30;
	//20080715 shimizu wrote
	//cp
	private int WIDTH2 = 30;
	private int HEIGHT2 = 80;
		
	public SearchResultListPanel(SearchResultDictionaryViewer parent,List<SearchResult> results,Region region) {
		this(parent,results,region,-1);
	}
	public SearchResultListPanel(SearchResultDictionaryViewer parent,List<SearchResult> results,Region region,int size_to_display) {
		super(parent,results,region);
		if(size_to_display == -1){
			this.SIZE_TO_DISPLAY = ROW * COLUMN;
		}else{
			this.SIZE_TO_DISPLAY = size_to_display;
		}
		this.setLayout(new FlowLayout());
		this.nextCount = this.count + 1;
		this.createNextResults(this.count);
		this.showResult(this.nextResults);
		this.createNextResults(nextCount);
	}
	@Override
	protected JLabel createImageLabel(SearchResult result) {
		int width;
		int height;
		if(result.getLineDirection() == LineDirection.HORIZONTAL){
			width = WIDTH1;
			height = HEIGHT1;
		}else{
			width = WIDTH2;
			height = HEIGHT2;
		}
		Spread spread = result.getSpread();
		Rectangle2D rect = result.getRectangle();
		
		Image image = new ImageCropper(spread,rect).crop(width,height);
		
		JLabel label = new JLabel(new ImageIcon(image));
		
		JWindow window = new ResultPopupWindow(result);
		label.addMouseListener(new LabelMouseListener(label,window,spread,rect));
		return label;
	}
}
