/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.text_search.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.dictionary.DictionaryDialog;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.spread_selection.ScopePanelAction;
import smart_gs.spread_selection.SetScopePanel;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.text_search.SearchTextAction;
import smart_gs.text_search.swingui.SearchResultViewer;

public class TextSearchPanel
extends JPanel {
    private SetScopePanel scopePanel;
    private JRadioButton allType;
    private JRadioButton firstIDAT;
    private JRadioButton userNote;
    private JRadioButton secondIDAT;
    private JRadioButton thirdIDAT;
    private JTextField queryTextPane;
    private JTextField queryReplacePane;
    private JCheckBox caseSensitiveBox;
    private JCheckBox regularExpressionsBox;
    private String queryText = null;
    private JButton search;
    private JButton replace;
    private static boolean allTypeSelected = true;
    private static boolean firstidatSelected;
    private static boolean userNoteSelected;
    private static boolean secondidatSelected;
    private static boolean thirdidatSelected;
    private static String queryTextPaneText;
    private static String queryReplacePaneText;
    private static boolean caseSensitiveBoxSelected;
    private static boolean regularExpressionsBoxSelected;

    public TextSearchPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        JPanel queryTextPanel = new JPanel();
        queryTextPanel.setLayout(new BorderLayout());
        queryTextPanel.setBorder(new TitledBorder(""));
        this.queryTextPane = new JTextField();
        this.queryTextPane.setFont(new Font("default", 0, 12));
        this.queryTextPane.setText(queryTextPaneText);
        this.queryReplacePane = new JTextField();
        this.queryReplacePane.setFont(new Font("default", 0, 12));
        this.queryReplacePane.setText(queryReplacePaneText);
        GridBagConstraints c = new GridBagConstraints();
        JPanel findPanel = new JPanel(new GridBagLayout());
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 2, 0);
        c.anchor = 17;
        findPanel.add((Component)new JLabel("Find:"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        findPanel.add((Component)this.queryTextPane, c);
        c.gridy = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 2, 0);
        c.anchor = 17;
        findPanel.add((Component)new JLabel("Replace With:"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        findPanel.add((Component)this.queryReplacePane, c);
        queryTextPanel.add((Component)findPanel, "Center");
        Panel boxPanel = new Panel();
        boxPanel.setLayout(new BorderLayout());
        this.caseSensitiveBox = new JCheckBox("Case sensitive");
        this.regularExpressionsBox = new JCheckBox("Regular expressions");
        boxPanel.add((Component)this.regularExpressionsBox, "West");
        boxPanel.add((Component)this.caseSensitiveBox, "Center");
        queryTextPanel.add((Component)boxPanel, "South");
        mainPanel.add((Component)queryTextPanel, "North");
        JPanel optionPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)optionPanel, "Center");
        this.scopePanel = new SetScopePanel(false);
        this.scopePanel.setScopePanelAction(new TextSearchDialogScopePanelAction());
        optionPanel.add((Component)this.scopePanel, "West");
        JPanel documentTypePanel = new JPanel(new GridLayout(5, 1));
        documentTypePanel.setBorder(new TitledBorder("Document Type"));
        this.userNote = new JRadioButton("UsersNote");
        this.userNote.setSelected(userNoteSelected);
        this.firstIDAT = new JRadioButton(Preference.getInstance().getFirstIDATName());
        this.firstIDAT.setSelected(firstidatSelected);
        this.secondIDAT = new JRadioButton(Preference.getInstance().getSecondIDATName());
        this.secondIDAT.setSelected(secondidatSelected);
        this.thirdIDAT = new JRadioButton(Preference.getInstance().getThirdIDATName());
        this.thirdIDAT.setSelected(thirdidatSelected);
        this.allType = new JRadioButton("All");
        this.allType.setSelected(allTypeSelected);
        this.caseSensitiveBox.setSelected(caseSensitiveBoxSelected);
        this.regularExpressionsBox.setSelected(regularExpressionsBoxSelected);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.firstIDAT);
        group2.add(this.secondIDAT);
        group2.add(this.thirdIDAT);
        group2.add(this.userNote);
        group2.add(this.allType);
        this.firstIDAT.addActionListener(new DocumentTypeSelectAction());
        this.secondIDAT.addActionListener(new DocumentTypeSelectAction());
        this.thirdIDAT.addActionListener(new DocumentTypeSelectAction());
        this.userNote.addActionListener(new DocumentTypeSelectAction());
        this.allType.addActionListener(new DocumentTypeSelectAction());
        documentTypePanel.add(this.firstIDAT);
        documentTypePanel.add(this.secondIDAT);
        documentTypePanel.add(this.thirdIDAT);
        documentTypePanel.add(this.userNote);
        documentTypePanel.add(this.allType);
        optionPanel.add((Component)documentTypePanel, "East");
        JPanel buttonPanel = new JPanel();
        this.search = new JButton("Search");
        this.search.addActionListener(new SearchAction());
        buttonPanel.add(this.search);
        this.replace = new JButton("Replace");
        this.replace.addActionListener(new ReplaceAction());
        buttonPanel.add(this.replace);
        mainPanel.add((Component)buttonPanel, "South");
    }

    private void search(String queryText, int documentType, boolean isCaseSensitive, boolean isRegularExpressions) {
        List<Spread> spreads = this.scopePanel.getSpreadsToSearch();
        ArrayList<Spread> spreadsToSearch = new ArrayList<Spread>();
        for (int i = 0; i < spreads.size(); ++i) {
            spreadsToSearch.add(spreads.get(i));
        }
        SearchTextAction searchAction = new SearchTextAction(queryText, spreadsToSearch, documentType, isCaseSensitive, isRegularExpressions);
        searchAction.execute();
        ArrayList results = (ArrayList)searchAction.getResults();
        new SearchResultViewer(queryText, results).setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
    }

    class TextSearchDialogScopePanelAction
    implements ScopePanelAction {
        TextSearchDialogScopePanelAction() {
        }

        @Override
        public void actionPerformed(SetScopePanel setScopePanel) {
            if (setScopePanel.isImageDictionary()) {
                TextSearchPanel.this.allType.setEnabled(false);
                TextSearchPanel.this.firstIDAT.setEnabled(false);
                TextSearchPanel.this.userNote.setEnabled(false);
                TextSearchPanel.this.secondIDAT.setEnabled(false);
                TextSearchPanel.this.thirdIDAT.setEnabled(false);
                TextSearchPanel.this.replace.setEnabled(false);
            } else {
                TextSearchPanel.this.allType.setEnabled(true);
                TextSearchPanel.this.firstIDAT.setEnabled(true);
                TextSearchPanel.this.userNote.setEnabled(true);
                TextSearchPanel.this.secondIDAT.setEnabled(true);
                TextSearchPanel.this.thirdIDAT.setEnabled(true);
                TextSearchPanel.this.replace.setEnabled(true);
            }
        }
    }

    private class ReplaceAction
    implements ActionListener {
        int documentType;

        private ReplaceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextSearchPanel.this.queryText = TextSearchPanel.this.queryTextPane.getText();
            if (TextSearchPanel.this.queryText.equals("")) {
                JOptionPane.showMessageDialog(null, "type any text");
            } else if (!TextSearchPanel.this.scopePanel.isImageDictionary()) {
                queryTextPaneText = TextSearchPanel.this.queryText;
                queryReplacePaneText = TextSearchPanel.this.queryReplacePane.getText();
                firstidatSelected = TextSearchPanel.this.firstIDAT.isSelected();
                thirdidatSelected = TextSearchPanel.this.thirdIDAT.isSelected();
                secondidatSelected = TextSearchPanel.this.secondIDAT.isSelected();
                allTypeSelected = TextSearchPanel.this.allType.isSelected();
                userNoteSelected = TextSearchPanel.this.userNote.isSelected();
                caseSensitiveBoxSelected = TextSearchPanel.this.caseSensitiveBox.isSelected();
                regularExpressionsBoxSelected = TextSearchPanel.this.regularExpressionsBox.isSelected();
                if (TextSearchPanel.this.firstIDAT.isSelected()) {
                    this.documentType = 1;
                } else if (TextSearchPanel.this.thirdIDAT.isSelected()) {
                    this.documentType = 3;
                } else if (TextSearchPanel.this.secondIDAT.isSelected()) {
                    this.documentType = 2;
                } else if (TextSearchPanel.this.allType.isSelected()) {
                    this.documentType = 4;
                } else if (TextSearchPanel.this.userNote.isSelected()) {
                    this.documentType = 5;
                }
                SearchAllDialogManager.setting(TextSearchPanel.this.queryText, queryReplacePaneText, regularExpressionsBoxSelected, caseSensitiveBoxSelected);
                int scope = 0;
                String spreadSelection = "";
                if (TextSearchPanel.this.scopePanel.isAll()) {
                    scope = 0;
                } else if (TextSearchPanel.this.scopePanel.isCurrentDirectory()) {
                    scope = 1;
                } else if (TextSearchPanel.this.scopePanel.isSelectSpread()) {
                    scope = 2;
                    spreadSelection = TextSearchPanel.this.scopePanel.getSelectedPage();
                }
                SearchAllDialogManager.findfirst(this.documentType, scope, spreadSelection);
            }
        }
    }

    private class DocumentTypeSelectAction
    implements ActionListener {
        private DocumentTypeSelectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TextSearchPanel.this.userNote.isSelected()) {
                TextSearchPanel.this.scopePanel.setEnabled(false);
            } else {
                TextSearchPanel.this.scopePanel.setEnabled(true);
            }
        }
    }

    private class SearchAction
    implements ActionListener {
        int documentType;

        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextSearchPanel.this.queryText = TextSearchPanel.this.queryTextPane.getText();
            if (TextSearchPanel.this.queryText.equals("")) {
                JOptionPane.showMessageDialog(null, "type any text");
            } else if (TextSearchPanel.this.scopePanel.isImageDictionary()) {
                DictionaryDialog dictionaryDialog = new DictionaryDialog((Frame)WorkspaceWindow.getInstance(), "Dictionary", false, 0);
                dictionaryDialog.search(TextSearchPanel.this.queryText, TextSearchPanel.this.regularExpressionsBox.isSelected(), TextSearchPanel.this.caseSensitiveBox.isSelected());
                dictionaryDialog.setVisible(true);
            } else {
                queryTextPaneText = TextSearchPanel.this.queryText;
                queryReplacePaneText = TextSearchPanel.this.queryReplacePane.getText();
                firstidatSelected = TextSearchPanel.this.firstIDAT.isSelected();
                thirdidatSelected = TextSearchPanel.this.thirdIDAT.isSelected();
                secondidatSelected = TextSearchPanel.this.secondIDAT.isSelected();
                allTypeSelected = TextSearchPanel.this.allType.isSelected();
                userNoteSelected = TextSearchPanel.this.userNote.isSelected();
                caseSensitiveBoxSelected = TextSearchPanel.this.caseSensitiveBox.isSelected();
                regularExpressionsBoxSelected = TextSearchPanel.this.regularExpressionsBox.isSelected();
                if (TextSearchPanel.this.firstIDAT.isSelected()) {
                    this.documentType = 1;
                } else if (TextSearchPanel.this.thirdIDAT.isSelected()) {
                    this.documentType = 3;
                } else if (TextSearchPanel.this.secondIDAT.isSelected()) {
                    this.documentType = 2;
                } else if (TextSearchPanel.this.allType.isSelected()) {
                    this.documentType = 4;
                } else if (TextSearchPanel.this.userNote.isSelected()) {
                    this.documentType = 5;
                }
                TextSearchPanel.this.search(TextSearchPanel.this.queryText, this.documentType, TextSearchPanel.this.caseSensitiveBox.isSelected(), TextSearchPanel.this.regularExpressionsBox.isSelected());
            }
        }
    }
}

