/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.SegfoFileFilter;
import smart_gs.util.SegfoToLineConverter;

public class ReadSegmentInfoAction
implements ActionListener {
    private String file_contents;
    private LineSegEditor editor;
    private Spread spread;
    private String file_name;
    private List<LineSegmentForEdit> lines = null;
    private JFileChooser chooser;

    public ReadSegmentInfoAction(LineSegEditor parent) {
        this.editor = parent;
        this.spread = this.editor.getSpread();
        this.file_name = this.spread.getFileName();
        this.chooser = new JFileChooser(Preference.getInstance().getImageFolderPathString() + this.spread.getFolderPath());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setFileFilter(new SegfoFileFilter());
        this.chooser.setFileSelectionMode(0);
        int input = this.chooser.showOpenDialog(WorkspaceWindow.getInstance());
        if (input == 1) {
            return;
        }
        File file = this.chooser.getSelectedFile();
        this.lines = new SegfoToLineConverter(this.spread).getLinesForEdit(file);
        this.editor.setLinesForEdit(this.lines);
        this.editor.rewriteLineSegIndexes();
        this.editor.repaint();
    }
}

