/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.smleditor.swingui;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import smart_gs.logical.SmartDocument;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygDocumentListener;
import smart_gs.smleditor.swingui.GSWysiwygMouseListener;
import smart_gs.swingui.ButtonFrame;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorFrame;

public class GSTextEditor
extends ButtonFrame
implements EditorFrame {
    private SmartDocument document;
    private JToolBar toolBar;
    private GSEditorTextPane textPane;

    public GSTextEditor(SmartDocument document) {
        super(document.getName());
        this.document = document;
        this.setDefaultCloseOperation(2);
        JPanel toolBarPanel = new JPanel(new FlowLayout(0));
        this.toolBar = new GSEditorToolBar(this.textPane);
        String xml = this.document.getSource();
        String source = null;
        if (xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")) {
            source = xml.substring("<xml><html>".length(), xml.length() - "</html><xml>".length());
        }
        this.textPane = new GSEditorTextPane(this.document, source);
        this.textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(this.textPane));
        this.textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(this.textPane));
        this.textPane.getGSHTMLEditorTextPane().setCaretPosition(0);
        this.setDefaultCloseOperation(2);
        toolBarPanel.add(this.toolBar);
        this.getContentPane().add((Component)toolBarPanel, "North");
        this.getContentPane().add((Component)this.textPane, "Center");
        this.setSize(400, 400);
        this.validate();
    }

    public GSTextEditor(SmartDocument document, String name) {
        super(document.getSource(), name);
        this.document = document;
        String xml = this.document.getSource();
        String source = null;
        if (xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")) {
            source = xml.substring("<xml><html>".length(), xml.length() - "</html><xml>".length());
        }
        this.textPane = new GSEditorTextPane(this.document, source);
        this.textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(this.textPane));
        this.textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(this.textPane));
        this.setDefaultCloseOperation(2);
        JPanel toolBarPanel = new JPanel(new FlowLayout(0));
        this.toolBar = new GSEditorToolBar(this.textPane);
        toolBarPanel.add(this.toolBar);
        this.getContentPane().add((Component)toolBarPanel, "North");
        this.getContentPane().add((Component)this.textPane, "Center");
        this.setSize(800, 600);
        this.validate();
    }

    @Override
    public void ok() {
        String source = this.textPane.getSource("body");
        this.document.setSource("<xml><html>" + source + "</html></xml>");
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    @Override
    public void setEditorToolBar(JToolBar toolbar) {
    }

    public void emphasize(String id) {
        this.textPane.emphasize(id);
    }

    public GSEditorTextPane getGSEditorTextPane() {
        return this.textPane;
    }
}

