/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui.view;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import reasoning_web.logical.ResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.view.SquareView;

public class ResourcePointerView
extends SquareView {
    private ResourcePointer element;
    private int X = 300;
    private int Y = 300;
    private int WIDTH = 15;
    private int HEIGHT = 15;
    private String uri;
    private String name = "";

    public ResourcePointerView(ResourcePointer element) {
        this.element = element;
        this.X = 300;
        this.Y = 300;
        this.uri = ((GS_RWElement)this.getElement().getRwElement()).getURI();
        this.rect = new Rectangle2D.Double(this.X, this.Y, this.WIDTH, this.HEIGHT);
    }

    @Override
    public void drawShape(Graphics2D g) {
        boolean zombified = this.element.isZombified();
        super.drawShape(g);
        int x = (int)this.rect.getMinX() + 20;
        int y = (int)this.rect.getCenterY() + 1;
        this.name = this.element.getName();
        String header = "";
        if (zombified) {
            header = "Zombie: ";
        }
        if (!this.name.equals("")) {
            g.drawString(header + this.name, x, y);
        } else {
            g.drawString(header + this.uri, x, y);
        }
        if (zombified) {
            g.fill(this.rect);
        }
    }

    @Override
    public String toString() {
        return "" + this.element;
    }

    public Rectangle2D getShape() {
        return this.rect;
    }

    public ResourcePointer getElement() {
        return this.element;
    }

    @Override
    public Rectangle2D getRectangle() {
        return this.rect;
    }

    @Override
    public void setRectangle(double x, double y, double w, double h) {
        this.rect = new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public void setRectangle(double x, double y) {
        this.rect = new Rectangle2D.Double(x, y, this.WIDTH, this.HEIGHT);
    }
}

