/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.logical;

import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.connection.lastConnectionToConfirmAndEditFrame;
import smart_gs.reasoning_web.logical.ExpNoteManager;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.view.ConnectionView;
import smart_gs.reasoning_web.swingui.view.View;

public class GSConnection
extends Connection
implements GS_RWElement {
    protected View view = new ConnectionView(this);

    protected GSConnection(ResourcePointer source, ResourcePointer target, ExplanatoryNote note, String uri, String originalURI, String version) {
        super(source, target, note, uri, originalURI, version);
    }

    protected GSConnection(ResourcePointer source, ResourcePointer target, ExplanatoryNote note) {
        super(source, target, note);
    }

    public View getView() {
        return this.view;
    }

    @Override
    public JPanel createElementViewPanel() throws NoWayToShowException {
        return ((GSExplanatoryNote)this.expNote).createElementViewPanel();
    }

    @Override
    public JPanel createElementViewPanel(int width, int height) throws NoWayToShowException {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Connection"));
        panel.setSize(width, height);
        return panel;
    }

    @Override
    public GSResourcePointer getSourcePointer() {
        return (GSResourcePointer)super.getSourcePointer();
    }

    @Override
    public GSResourcePointer getTargetPointer() {
        return (GSResourcePointer)super.getTargetPointer();
    }

    @Override
    public void show() {
        new lastConnectionToConfirmAndEditFrame(this, "Chosen Connection").setVisible(true);
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public Element createXMLElement(Document document) {
        Element element = document.createElement("connection");
        element.setAttribute("uri", this.uri);
        element.setAttribute("originalURI", this.originalURI);
        element.setAttribute("oldVersionURI", this.getOldVersionURI());
        element.setAttribute("version", this.version);
        element.setAttribute("name", this.name);
        Element sourceElem = ((GSResourcePointer)this.source).createXMLElement(document);
        sourceElem.setAttribute("type", "source");
        element.appendChild(sourceElem);
        Element targetElem = ((GSResourcePointer)this.target).createXMLElement(document);
        targetElem.setAttribute("type", "target");
        element.appendChild(targetElem);
        element.appendChild(((GSExplanatoryNote)this.expNote).createXMLElement(document));
        return element;
    }

    public static GSConnection restore(Element element) {
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String oldVersionURI = element.getAttribute("oldVersionURI");
        String version = element.getAttribute("version");
        String name = element.getAttribute("name");
        GSResourcePointer source = null;
        GSResourcePointer target = null;
        NodeList list = element.getElementsByTagName("pointer");
        Element elem1 = (Element)list.item(0);
        String type = elem1.getAttribute("type");
        if (type.equals("source")) {
            source = GSResourcePointer.restore(elem1);
        } else {
            target = GSResourcePointer.restore(elem1);
        }
        Element elem2 = (Element)list.item(1);
        String type2 = elem2.getAttribute("type");
        if (type2.equals("source")) {
            source = GSResourcePointer.restore(elem2);
        } else {
            target = GSResourcePointer.restore(elem2);
        }
        Element noteElement = (Element)element.getElementsByTagName("explanatory").item(0);
        GSExplanatoryNote note = GSExplanatoryNote.restore(noteElement);
        ExpNoteManager.getInstance().addNote(note);
        GSConnection connection = new GSConnection(source, target, note, uri, originalURI, version);
        connection.setOldVersionURI(oldVersionURI);
        connection.setVersion(version);
        connection.setName(name);
        return connection;
    }
}

