/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.normal.swingui;

import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.normal.swingui.AbstractSearchResultPanel;
import smart_gs.image_search.normal.swingui.LabelMouseListener;
import smart_gs.image_search.normal.swingui.ResultPopupWindow;
import smart_gs.image_search.normal.swingui.SearchResultViewer;
import smart_gs.logical.Spread;
import smart_gs.util.ImageCropper;
import sml_editor.logical.LineDirection;

public class SearchResultPanelOfSegmentMode
extends AbstractSearchResultPanel {
    private int row;
    private int column;
    private int widthCorrectionHmode = 50;
    private int heightCorrectionHmode = 0;
    private int widthCorrectionVmode = 0;
    private int heightCorrectionVmode = 50;
    private double magnification = 0.7;

    public SearchResultPanelOfSegmentMode(SearchResultViewer parent, List<SearchResult> results, Image queryImage, LineDirection lineDirection) {
        super(parent, results, queryImage, lineDirection);
        if (this.lineDirection == LineDirection.HORIZONTAL) {
            this.row = 6;
            this.column = 5;
            if (queryImage.getWidth(this) < queryImage.getHeight(this)) {
                int tmp = this.column;
                this.column = this.row;
                this.row = tmp;
            }
        } else {
            this.row = 4;
            this.column = 6;
            if (queryImage.getWidth(this) > queryImage.getHeight(this)) {
                int tmp = this.column;
                this.column = this.row;
                this.row = tmp;
            }
        }
        this.SIZE_TO_DISPLAY = this.row * this.column;
        this.setLayout(new GridLayout(this.row, this.column));
        this.nextCount = this.count + 1;
        this.createNextResults(this.count);
        this.showResult(this.nextResults);
        this.createNextResults(this.nextCount);
    }

    @Override
    protected JLabel createImageLabel(SearchResult result, Image queryImage) {
        double ratio2;
        Spread spread = result.getSpread();
        Rectangle rect = result.getRectangle();
        int width = queryImage.getWidth(null);
        int height = queryImage.getHeight(null);
        if (this.lineDirection == LineDirection.HORIZONTAL) {
            width += this.widthCorrectionHmode;
            height += this.heightCorrectionHmode;
        } else {
            width += this.widthCorrectionVmode;
            height += this.heightCorrectionVmode;
        }
        width = (int)((double)width * this.magnification);
        height = (int)((double)height * this.magnification);
        if (this.lineDirection == LineDirection.HORIZONTAL && height > 50) {
            ratio2 = 50.0 / (double)height;
            width = (int)((double)width * ratio2);
            height = (int)((double)height * ratio2);
        } else if (this.lineDirection != LineDirection.HORIZONTAL && width > 50) {
            ratio2 = 50.0 / (double)width;
            width = (int)((double)width * ratio2);
            height = (int)((double)height * ratio2);
        }
        Image image = new ImageCropper(spread, (Rectangle2D)rect).crop(width, height);
        JLabel label = new JLabel(new ImageIcon(image));
        ResultPopupWindow window = new ResultPopupWindow(result);
        label.addMouseListener(new LabelMouseListener(label, window, spread, rect));
        return label;
    }
}

