/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search;

import image_search.Query;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import jp.ac.hokudai.meme.core_smart_gs.searcher.FoundRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.InputStreamThread;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PagedPolygon;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PagedRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PolygonParser;
import jp.ac.hokudai.meme.core_smart_gs.searcher.ResultRects;
import smart_gs.SmartGS;
import smart_gs.image_search.normal.swingui.SetSearchOptionPanel;
import smart_gs.logical.Spread;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.Pair;
import sml_editor.logical.LineDirection;

public class ExternalSearchEngineController {
    private ResultRects resultRects = new ResultRects();
    static final String COM_ASSIGN = "assign";
    static final String COM_SEARCH = "search";
    static final String COM_EXIT = "exit";
    static final String PREFIX_P0 = "p0";
    static final String PREFIX_X = "x";
    static final String PREFIX_Y = "y";
    static final String REGEXP_RECORD = "r(\\d+)d(\\d+\\.?\\d+)(.*)";
    static final String MSG_OK = "OK";
    static final String RECORD_EOD = "EOD";
    static final String ERRMSG_PARSE = "Internal Error: parse error";
    static final double CAPACITY = 2.0E8;
    static final int maxRank = 100;
    boolean cocurrentSearch = true;

    public void setConcurrentSearch() {
        this.cocurrentSearch = true;
    }

    public void setSequentialSearch() {
        this.cocurrentSearch = false;
    }

    public ResultRects search(Query query, List<Spread> spreads) {
        int i;
        List<Spread> sourceSpreadList = spreads;
        int startIndex = 0;
        int max = sourceSpreadList.size();
        double tmpSpreadsListTotalSize = 0.0;
        ArrayList<Spread> tmpSpreadsListToSearch = new ArrayList<Spread>();
        ArrayList dividedListsWithStartIndex = new ArrayList();
        double capacity = 2.0E8 * (double)SetSearchOptionPanel.getPos();
        if (SetSearchOptionPanel.isConcurrent()) {
            this.setConcurrentSearch();
        } else {
            this.setSequentialSearch();
        }
        int i2 = 0;
        while (i2 < max) {
            Spread spread = sourceSpreadList.get(i2);
            File dscFile = spread.getDscFile();
            long ln = dscFile.length();
            if (!((double)ln < capacity)) {
                JOptionPane.showMessageDialog(null, "Dsc file for " + Spread.getFileNameWithoutExtension(dscFile) + " is too large to search");
                return new ResultRects();
            }
            if (tmpSpreadsListTotalSize + (double)ln > capacity) {
                dividedListsWithStartIndex.add(new Pair(startIndex, tmpSpreadsListToSearch));
                startIndex += tmpSpreadsListToSearch.size();
                tmpSpreadsListToSearch = new ArrayList();
                tmpSpreadsListTotalSize = 0.0;
                continue;
            }
            tmpSpreadsListToSearch.add(spread);
            tmpSpreadsListTotalSize += (double)ln;
            if (++i2 != max) continue;
            dividedListsWithStartIndex.add(new Pair(startIndex, tmpSpreadsListToSearch));
        }
        int sizeOfDivided = dividedListsWithStartIndex.size();
        DscSearchThread[] dscSearchThread = new DscSearchThread[sizeOfDivided];
        for (i = 0; i < sizeOfDivided; ++i) {
            dscSearchThread[i] = new DscSearchThread(query, (Pair)dividedListsWithStartIndex.get(i));
            dscSearchThread[i].start();
            if (this.cocurrentSearch) continue;
            try {
                dscSearchThread[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.cocurrentSearch) {
            for (i = 0; i < sizeOfDivided; ++i) {
                try {
                    dscSearchThread[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        ResultRects[] resultRects = new ResultRects[sizeOfDivided];
        resultRects[0] = this.getResultRectsFromStrings(dscSearchThread[0].getResultStringList());
        for (int i3 = 1; i3 < sizeOfDivided; ++i3) {
            Integer j = (Integer)((Pair)dividedListsWithStartIndex.get(i3)).getLeft();
            resultRects[i3] = this.getResultRectsFromStrings(dscSearchThread[i3].getResultStringList());
            resultRects[i3] = this.resultRectsRemoveZeroPageResultsAndIncrementPageNumberBy(j - 1, resultRects[i3]);
        }
        return this.mergeResults(resultRects);
    }

    public ResultRects resultRectsRemoveZeroPageResultsAndIncrementPageNumberBy(int incr, ResultRects resultRects) {
        ResultRects newResultRects = new ResultRects();
        for (int r = 1; r <= 100; ++r) {
            PagedRect[] pagedRectArray = resultRects.getPRects(r);
            double score = resultRects.getScore(r);
            ArrayList<PagedRect> newPagedRectsList = new ArrayList<PagedRect>();
            for (int i = 0; i < pagedRectArray.length; ++i) {
                int pageIndex = pagedRectArray[i].getPageIndex();
                if (pageIndex == 0) continue;
                PagedRect newPagedRect = new PagedRect(i + incr, pagedRectArray[i].getRect());
                newPagedRectsList.add(newPagedRect);
            }
            PagedRect[] tmp = new PagedRect[newPagedRectsList.size()];
            for (int i = 0; i < newPagedRectsList.size(); ++i) {
                tmp[i] = (PagedRect)newPagedRectsList.get(i);
            }
            newResultRects.addResult(new FoundRect(tmp, score));
        }
        return newResultRects;
    }

    private ResultRects mergeResults(ResultRects[] resultRectsArray) {
        ResultRects mergedResultRects = resultRectsArray[0];
        int size = resultRectsArray.length;
        for (int i = 1; i < size; ++i) {
            mergedResultRects = this.merge(mergedResultRects, resultRectsArray[i]);
        }
        return mergedResultRects;
    }

    private ResultRects merge(ResultRects leftRRs, ResultRects rightRRs) {
        ResultRects ans = new ResultRects();
        int leftRank = 1;
        int rightRank = 1;
        for (int i = 1; i <= 100; ++i) {
            int j;
            double rightScore;
            double leftScore = leftRRs.getScore(leftRank);
            if (leftScore < (rightScore = leftRRs.getScore(rightRank))) {
                ans.addResult(leftRRs.getFoundRect(leftRank));
                ++leftRank;
                continue;
            }
            if (leftScore > rightScore) {
                ans.addResult(rightRRs.getFoundRect(rightRank));
                ++rightRank;
                continue;
            }
            PagedRect[] leftPRs = leftRRs.getFoundRect(leftRank).getPRects();
            PagedRect[] rightPRs = rightRRs.getFoundRect(rightRank).getPRects();
            PagedRect[] mergedPRs = new PagedRect[leftPRs.length + rightPRs.length];
            for (j = 0; j < leftPRs.length; ++j) {
                mergedPRs[j] = leftPRs[j];
            }
            for (j = 0; j < rightPRs.length; ++j) {
                mergedPRs[j + leftPRs.length] = rightPRs[j];
            }
            ans.addResult(new FoundRect(mergedPRs, leftScore));
            ++leftRank;
            ++rightRank;
        }
        return ans;
    }

    private File makeAssignListFile(Integer index, List<Spread> spreads) {
        String assignListPath = SmartGS.getImageSearchAssignlistfilePathString(index);
        File file = new File(assignListPath);
        try {
            HashMap<String, String> dscLocation = new HashMap<String, String>();
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(assignListPath);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(osw);
            for (int i = 0; i < spreads.size(); ++i) {
                if (spreads.get(i).getDscFile() == null) continue;
                bw.write(CanonicalPathString.get(spreads.get(i).getFile()));
                bw.newLine();
                String bmp = spreads.get(i).getFile().getParent();
                String dsc = spreads.get(i).getDscFile().getParent();
                dscLocation.put(bmp, dsc);
            }
            bw.close();
            osw.close();
            fos.close();
            for (String key : dscLocation.keySet()) {
                File f = new File(key + "/DscLocation");
                FileOutputStream fosd = new FileOutputStream(f);
                OutputStreamWriter oswd = new OutputStreamWriter(fosd);
                BufferedWriter bwd = new BufferedWriter(oswd);
                bwd.write((String)dscLocation.get(key));
                bwd.close();
                oswd.close();
                fosd.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public String getStringFromRectangle(Rectangle rect, Spread spread) {
        StringBuffer queryStringBuffer = new StringBuffer();
        queryStringBuffer.append(PREFIX_P0);
        queryStringBuffer.append(PREFIX_X);
        queryStringBuffer.append((int)rect.getX());
        queryStringBuffer.append(PREFIX_Y);
        queryStringBuffer.append((int)rect.getY());
        if (spread.getLineDirection() == LineDirection.HORIZONTAL) {
            queryStringBuffer.append(PREFIX_X);
            queryStringBuffer.append((int)rect.getX() + (int)rect.getWidth());
            queryStringBuffer.append(PREFIX_Y);
            queryStringBuffer.append((int)rect.getY());
        } else {
            queryStringBuffer.append(PREFIX_X);
            queryStringBuffer.append((int)rect.getX());
            queryStringBuffer.append(PREFIX_Y);
            queryStringBuffer.append((int)rect.getY() + (int)rect.getHeight());
        }
        return queryStringBuffer.toString();
    }

    public ResultRects getResultRectsFromStrings(ArrayList<String> strs) {
        for (String recordString : strs) {
            if (recordString.equals(RECORD_EOD)) break;
            Pattern pat = Pattern.compile(REGEXP_RECORD);
            Matcher mat = pat.matcher(recordString);
            if (!mat.find()) {
                throw new RuntimeException(new ParseException(ERRMSG_PARSE, 0));
            }
            PolygonParser parser = new PolygonParser(mat.group(3));
            try {
                List<PagedPolygon> polygon = parser.getPolygon();
                PagedRect[] pagedRects = new PagedRect[polygon.size()];
                int idx = 0;
                for (PagedPolygon pagedPolygon : polygon) {
                    pagedRects[idx] = new PagedRect(pagedPolygon.getPageNum(), pagedPolygon.getPolygon().getBounds(), -1, -1);
                    ++idx;
                }
                FoundRect foundRect = new FoundRect(pagedRects, Double.parseDouble(mat.group(2)));
                this.resultRects.addResult(foundRect);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return this.resultRects;
    }

    public class DscSearchThread
    extends Thread {
        private Process p;
        private File assignListFile;
        private ArrayList<String> tmpResultStrings;
        private InputStreamThread it;
        private InputStreamThread et;
        private BufferedWriter bw;
        int startIndexToBeSearched = 0;
        ArrayList<String> resultStrings;
        Query query;
        Pair<Integer, List<Spread>> pair;

        DscSearchThread(Query query0, Pair<Integer, List<Spread>> pair0) {
            this.query = query0;
            this.pair = pair0;
            this.assignListFile = ExternalSearchEngineController.this.makeAssignListFile(this.pair.getLeft(), this.pair.getRight());
            this.tmpResultStrings = new ArrayList();
        }

        @Override
        public void run() {
            try {
                this.p = Runtime.getRuntime().exec(SmartGS.getImageSearchExefilePathString());
                this.it = new InputStreamThread(this.p.getInputStream(), 0, this);
                this.it.start();
                this.et = new InputStreamThread(this.p.getErrorStream(), 1, this);
                this.et.start();
                this.bw = new BufferedWriter(new OutputStreamWriter(this.p.getOutputStream()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                this.bw.write("assign " + CanonicalPathString.get(this.assignListFile));
                System.out.println("assign " + CanonicalPathString.get(this.assignListFile));
                this.bw.newLine();
                this.bw.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String queryString = ExternalSearchEngineController.this.getStringFromRectangle(this.query.getRectangle(), this.query.getSpread());
            int first = 1;
            int count = 100;
            try {
                this.bw.write("search " + queryString + " " + first + " " + count);
                System.out.println("search " + queryString + " " + first + " " + count);
                this.bw.newLine();
                this.bw.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                this.bw.write(ExternalSearchEngineController.COM_EXIT);
                this.bw.newLine();
                this.bw.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                this.it.join();
                this.et.join();
                this.p.getInputStream().close();
                this.p.getOutputStream().close();
                this.p.getErrorStream().close();
                this.p.destroy();
                this.assignListFile.delete();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void addSearchResult(String ret) {
            if (ret.equals(ExternalSearchEngineController.MSG_OK)) {
                return;
            }
            this.tmpResultStrings.add(ret);
        }

        public ArrayList<String> getResultStringList() {
            return this.tmpResultStrings;
        }
    }
}

