/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import smart_gs.drawing_tool.view.View;

public class AnchorView
extends View {
    private static int LEFT_MARGIN = 6;
    private static int TOP_MARGIN = 16;
    private static int DEFAULT_FONT_SIZE = 15;
    private static Font DEFAULT_FONT = new Font("Serif", 1, DEFAULT_FONT_SIZE);
    private static int id = 0;
    public static double WIDTH = 20.0;
    public static double HEIGHT = 25.0;
    public static Color ANCHOR_YELLOW = new Color(255, 255, 153);
    public static Color ANCHOR_CYAN = new Color(204, 255, 255);
    public static Color ANCHOR_MAGENTA = new Color(255, 153, 255);
    public static Color ANCHOR_GREEN = new Color(153, 255, 0);
    public static Color ANCHOR_RED = new Color(255, 51, 51);
    public static Color DEFAULT_COLOR = ANCHOR_YELLOW;
    protected Rectangle2D rectangle;
    protected Font font = DEFAULT_FONT;
    private Color color = DEFAULT_COLOR;
    private Color stroke_color = Color.BLACK;
    private boolean transparency = false;
    private double imageScale;

    public AnchorView(Rectangle2D rectangle) {
        this.rectangle = rectangle;
        this.defaultColor = Color.yellow;
    }

    public AnchorView(Rectangle2D rectangle, boolean isProtected) {
        this(rectangle);
        this.isProtected = isProtected;
    }

    public AnchorView(Rectangle2D rectangle, boolean isSelected, boolean isEmphasized, boolean isProtected) {
        this(rectangle);
        this.isSelected = isSelected;
        this.isEmphasized = isEmphasized;
        this.isProtected = isProtected;
    }

    @Override
    public boolean contains(Point2D point) {
        double x = this.rectangle.getX();
        double y = this.rectangle.getY();
        double w = this.rectangle.getWidth() / this.imageScale;
        double h = this.rectangle.getHeight() / this.imageScale;
        Rectangle2D.Double newRectangle = new Rectangle2D.Double(x, y, w, h);
        return newRectangle.contains(point);
    }

    @Override
    protected void drawShape(Graphics2D g) {
        if (this.isSelected) {
            this.drawSelectedIcon(g);
        }
        this.setBackgroundColor(g);
        g.fill(this.rectangle);
        this.setFrameStroke(g);
        g.draw(this.rectangle);
        float x = (float)this.rectangle.getX();
        float y = (float)this.rectangle.getY();
        double rect_width = this.rectangle.getWidth();
        double rect_height = this.rectangle.getHeight();
        g.setFont(this.font);
        if (!this.transparency) {
            g.setColor(Color.BLACK);
        }
        g.drawString("\u00b6", x + (float)LEFT_MARGIN, y + (float)TOP_MARGIN);
        if (this.isProtected) {
            double px = x - 4.0f;
            double py = y - 4.0f;
            double pw = rect_width + 8.0;
            double ph = rect_height + 8.0;
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(1.0f));
            g.draw(new Rectangle2D.Double(px, py, pw, ph));
        }
    }

    public void setBackgroundColor(Graphics2D g) {
        if (this.isSelected) {
            g.setColor(ANCHOR_RED);
        } else {
            g.setColor(this.color);
        }
    }

    public void setStrokeColor(Graphics2D g) {
        if (this.isProtected) {
            g.setColor(new Color(51, 102, 0));
        } else {
            g.setColor(Color.BLACK);
        }
    }

    public void setFrameStroke(Graphics2D g) {
        if (this.isSelected) {
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(2.0f));
        } else {
            g.setColor(this.stroke_color);
            g.setStroke(new BasicStroke(1.0f));
        }
        if (this.isProtected) {
            // empty if block
        }
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public void moveBy(Point2D d) {
        double x = this.rectangle.getX();
        double y = this.rectangle.getY();
        double width = this.rectangle.getWidth();
        double height = this.rectangle.getHeight();
        this.rectangle = new Rectangle2D.Double(x + d.getX(), y + d.getY(), width, height);
    }

    @Override
    public AnchorView enlargedView(double ratio, double gapX, double gapY) {
        this.imageScale = ratio;
        double x = this.rectangle.getX();
        double y = this.rectangle.getY();
        double w = this.rectangle.getWidth();
        double h = this.rectangle.getHeight();
        Rectangle2D.Double rect = new Rectangle2D.Double(x * ratio + gapX, y * ratio + gapY, w, h);
        AnchorView view = new AnchorView(rect, this.isSelected, this.isEmphasized, this.isProtected);
        view.font = this.font;
        view.color = this.color;
        view.stroke_color = this.stroke_color;
        view.transparency = this.transparency;
        return view;
    }

    @Override
    public Rectangle2D getRectangle2D() {
        return this.rectangle;
    }

    @Override
    public String getTypeString() {
        return "anchor";
    }

    @Override
    public void drawLinkedShape(Graphics2D g, Image image) {
        this.drawShape(g);
        this.drawLinkIcon(g, image);
    }

    @Override
    public void drawTemporaryShape(Graphics2D g, Image image) {
        this.drawShape(g);
        this.drawLinkIcon(g, image);
    }

    @Override
    public Element createXMLElement(Document document) {
        Element element = document.createElement("view");
        element.setAttribute("type", "anchor");
        element.setAttribute("title", this.title);
        element.setAttribute("x", this.rectangle.getX() + "");
        element.setAttribute("y", this.rectangle.getY() + "");
        element.setAttribute("width", this.rectangle.getWidth() + "");
        element.setAttribute("height", this.rectangle.getHeight() + "");
        element.setAttribute("color", AnchorView.colorToString(this.color));
        element.setAttribute("transparency", this.transparency + "");
        if (this.isProtected()) {
            element.setAttribute("protected", "PROTECTED");
        }
        return element;
    }

    public static View restore(Element elem) {
        double x = new Double(elem.getAttribute("x"));
        double y = new Double(elem.getAttribute("y"));
        double width = new Double(elem.getAttribute("width"));
        double height = new Double(elem.getAttribute("height"));
        boolean isProtected = elem.getAttribute("protection").equals("PROTECTED");
        String title = elem.getAttribute("title");
        AnchorView view = new AnchorView(new Rectangle2D.Double(x, y, width, height), isProtected);
        view.setTitle(title);
        view.color = AnchorView.stringToColor(elem.getAttribute("color"));
        if (new Boolean(elem.getAttribute("transparency")).booleanValue()) {
            view.transparentise();
        } else {
            view.opaque();
        }
        return view;
    }

    public void setRectangle(Rectangle2D rectangle) {
        this.rectangle = rectangle;
    }

    public Font getFont() {
        return this.font;
    }

    public static void drawStringList(Graphics2D g, ArrayList<String> text_list, int x, int y, int text_height, double rect_height) {
        int current_height = text_height;
        for (int i = 0; i < text_list.size(); ++i) {
            if ((double)current_height >= rect_height) {
                return;
            }
            if (i != text_list.size() - 1 && (double)(current_height + text_height) >= rect_height) {
                String s = text_list.get(i);
                int l = s.length();
                if (l >= 1) {
                    String ss = s.substring(0, l - 1) + "..";
                    g.drawString(ss, x, y);
                }
                return;
            }
            g.drawString(text_list.get(i), x, y);
            y += text_height;
            current_height += text_height;
        }
    }

    public void setColor(Color c) {
        this.color = c;
        if (this.transparency) {
            this.transparentise();
        }
    }

    @Override
    public void setViewColor(View.ViewColor c) {
        this.transparency = false;
        switch (c) {
            case YELLOW: {
                this.color = ANCHOR_YELLOW;
                return;
            }
            case CYAN: {
                this.color = ANCHOR_CYAN;
                return;
            }
            case MAGENTA: {
                this.color = ANCHOR_MAGENTA;
                return;
            }
            case GREEN: {
                this.color = ANCHOR_GREEN;
                return;
            }
            case TRANSPARENT: {
                this.transparentise();
                return;
            }
            case OPAQUE: {
                this.opaque();
                return;
            }
        }
        this.color = ANCHOR_YELLOW;
    }

    public void transparentise() {
        this.transparency = true;
        int red = this.color.getRed();
        int green = this.color.getGreen();
        int blue = this.color.getBlue();
        this.color = new Color(red, green, blue, 120);
        this.stroke_color = new Color(red, green, blue, 255);
    }

    public void opaque() {
        this.transparency = false;
        int red = this.color.getRed();
        int green = this.color.getGreen();
        int blue = this.color.getBlue();
        this.color = new Color(red, green, blue, 255);
        this.stroke_color = Color.BLACK;
    }

    public boolean isTransparent() {
        return this.transparency;
    }

    public static void setDefaultColor(AnchorColor c) {
        switch (c) {
            case YELLOW: {
                DEFAULT_COLOR = ANCHOR_YELLOW;
                return;
            }
            case CYAN: {
                DEFAULT_COLOR = ANCHOR_CYAN;
                return;
            }
            case MAGENTA: {
                DEFAULT_COLOR = ANCHOR_MAGENTA;
                return;
            }
            case GREEN: {
                DEFAULT_COLOR = ANCHOR_GREEN;
                return;
            }
        }
        DEFAULT_COLOR = ANCHOR_YELLOW;
    }

    private static String colorToString(Color c) {
        if (c.equals(ANCHOR_YELLOW)) {
            return "yellow";
        }
        if (c.equals(ANCHOR_CYAN)) {
            return "cyan";
        }
        if (c.equals(ANCHOR_MAGENTA)) {
            return "magenta";
        }
        return "green";
    }

    private static Color stringToColor(String s) {
        if (s.equals("yellow")) {
            return ANCHOR_YELLOW;
        }
        if (s.equals("cyan")) {
            return ANCHOR_CYAN;
        }
        if (s.equals("magenta")) {
            return ANCHOR_MAGENTA;
        }
        return ANCHOR_GREEN;
    }

    @Override
    public Point getCenterPoint() {
        return new Point((int)this.getRectangle2D().getCenterX(), (int)this.getRectangle2D().getCenterY());
    }

    public static void setDefaultColor(Color color) {
        DEFAULT_COLOR = color;
    }

    @Override
    public String getTypeStringForDisplay() {
        return "Anchor";
    }

    @Override
    public void drawLinkIcon(Graphics2D g, Image image) {
        Rectangle rect = this.getRectangle();
        int w = image.getWidth(null) / 3;
        int h = image.getHeight(null) / 3;
        int x = (int)(rect.getX() + rect.getWidth() - (double)(w / 3));
        int y = (int)rect.getY() - h / 2;
        g.drawImage(image, x, y, w, h, null);
    }

    @Override
    public void drawTemporaryIcon(Graphics2D g) {
        Image image = new ImageIcon("./icons/remove.png").getImage();
        Rectangle rect = this.getRectangle();
        int w = image.getWidth(null) / 3;
        int h = image.getHeight(null) / 3;
        int x = (int)(rect.getX() + rect.getWidth() - (double)(w / 3));
        int y = (int)rect.getY() - h / 2;
        g.drawImage(image, x, y, w, h, null);
    }

    @Override
    public void drawSelectedIcon(Graphics2D g) {
        ImageIcon selected = new ImageIcon("./icons/selected_mark.png");
        Image image = selected.getImage();
        Rectangle rect = this.getRectangle();
        int w = image.getWidth(null) / 3;
        int h = image.getHeight(null) / 3;
        int x = (int)rect.getX() - w;
        int y = (int)rect.getY() - h;
        g.drawImage(image, x, y, w, h, null);
    }

    public static enum AnchorColor {
        YELLOW,
        CYAN,
        MAGENTA,
        GREEN,
        RED,
        TRANSPARENT,
        OPAQUE;

    }
}

