/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.state;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import smart_gs.current_text_search.CurrentSearchTextWithoutDialog;
import smart_gs.drawing_tool.DrawingModeSelectionPopupMenu;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.AnchorMode;
import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultStateEvent;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.StateEvent;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.tmpDrawingModeSelectionPopupMenu;
import smart_gs.logical.Preference;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.smleditor.swingui.IDATPanel;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;
import smart_gs.util.WindowByMouseEvent;

public class DefaultState
implements State {
    protected static DefaultState singleton = new DefaultState();
    private Mode mode = new DefaultDrawingMode();
    private ArrayList<StateEvent> eventList = new ArrayList();
    private Cursor cursor;

    protected DefaultState() {
        this.mode = DefaultDrawingMode.getInstance();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static DefaultState getInstance() {
        return singleton;
    }

    public void setMode(Mode mode) {
        this.mode.cancel();
        this.mode = mode;
        for (int i = 0; i < this.eventList.size(); ++i) {
            StateEvent stateEvent = this.eventList.get(i);
            stateEvent.setMoveEvent(mode);
        }
        this.changeCursorTo(mode);
    }

    public static void setDefaultState(DefaultState state) {
        singleton = state;
        ImageLabel.setState(state);
    }

    public static void restoreDefaultState() {
        singleton = new DefaultState();
        ImageLabel.setState(singleton);
    }

    @Override
    public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
        boolean ctrlPressed = WorkspaceWindow.getInstance().isCtrl();
        boolean altPressed = WorkspaceWindow.getInstance().isAlt();
        boolean shiftPressed = WorkspaceWindow.getInstance().isShift();
        int clickCount = e.getClickCount();
        int button = e.getButton();
        if (ctrlPressed && button == 1 && clickCount == 1) {
            DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
            new ImageToolBarSetModeByMouseEvent().setMode(e, ImageToolBar.modeNone);
            this.changeCursorTo(DefaultDrawingMode.getInstance());
            return;
        }
        if (button == 3) {
            if (altPressed) {
                return;
            }
            if (ctrlPressed) {
                return;
            }
            if (shiftPressed) {
                this.tempRegionRightButtonClickAction(e);
            } else {
                this.rightButtonClickAction(e);
            }
            return;
        }
        if (button == 1 && clickCount == 1 && altPressed) {
            if (ctrlPressed) {
                return;
            }
            if (shiftPressed) {
                this.tempRegionRightButtonClickAction(e);
            } else {
                this.rightButtonClickAction(e);
            }
            return;
        }
        Mode mode = this.getMode();
        AbstractGSWindow window = new WindowByMouseEvent().getWindow(e);
        if (button == 1 && clickCount == 2 && !ctrlPressed && !altPressed && !shiftPressed && mode instanceof DefaultDrawingMode) {
            int index = canvas.getImageLabel().getLineIndex(e.getX(), e.getY());
            if (index >= 0) {
                if (window instanceof WorkspaceWindow) {
                    GSTabbedPane wrkspcwindowTabbedPane = WorkspaceWindow.getInstance().getTabbedPane();
                    wrkspcwindowTabbedPane.setSelectedIndex(0);
                    IDATPanel fstIdatPanel = (IDATPanel)wrkspcwindowTabbedPane.getSelectedComponent();
                    GSEditorToolBar toolbar = fstIdatPanel.getGSEditorToolBar();
                    ((WorkspaceWindow)window).getGSEditorToolBar().getEditorTextPane().highlightOff();
                    CurrentSearchTextWithoutDialog.search(toolbar, "$" + index + "$");
                } else if (window instanceof GSEditor) {
                    GSEditor editor = (GSEditor)window;
                    GSTabbedPane editorTabbedPane = editor.getTabbedPane();
                    editorTabbedPane.setSelectedIndex(0);
                    IDATPanel fstIdatPanel = editorTabbedPane.getFirstIDATPanel();
                    editorTabbedPane.setSelectedComponent(fstIdatPanel);
                    GSEditorToolBar toolbar = fstIdatPanel.getGSEditorToolBar();
                    editorTabbedPane.getFirstIDAT().highlightOff();
                    CurrentSearchTextWithoutDialog.search(toolbar, "$" + index + "$");
                }
            }
        } else {
            this.mode.mouseClicked(e, canvas);
        }
        this.mode.mouseClicked(e, canvas);
    }

    private void tempRegionRightButtonClickAction(GSMouseEvent e) {
        tmpDrawingModeSelectionPopupMenu menu = new tmpDrawingModeSelectionPopupMenu(e);
        menu.show(e.getComponent(), e.getOriginalPoint().x, e.getOriginalPoint().y);
        GlobalViewPanel.getInstance().repaint();
    }

    private void rightButtonClickAction(GSMouseEvent e) {
        DrawingModeSelectionPopupMenu menu = new DrawingModeSelectionPopupMenu(e);
        menu.show(e.getComponent(), e.getOriginalPoint().x, e.getOriginalPoint().y);
        GlobalViewPanel.getInstance().repaint();
    }

    @Override
    public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
        this.mode.mouseDragged(e, canvas);
    }

    @Override
    public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
        this.mode.mouseEntered(e, canvas);
    }

    @Override
    public void mouseExited(GSMouseEvent e, SpreadCanvas canvas) {
        this.mode.mouseExited(e, canvas);
    }

    @Override
    public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
        this.mode.mouseMoved(e, canvas);
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.mode != EraserMode.getInstance()) {
            this.mode.mousePressed(e, canvas);
        }
        canvas.getSpread().clearSelection();
        if (!WorkspaceWindow.getInstance().isAlt() && canvas.containRegions(e.getPoint())) {
            this.mode.cancel();
            UniSelectedState state = UniSelectedState.getInstance();
            ImageLabel.setState(state);
            state.mousePressed(e, canvas);
        }
    }

    @Override
    public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
        this.mode.mouseReleased(e, canvas);
    }

    @Override
    public void paint(Graphics g, SpreadCanvas canvas) {
        this.mode.paint(g, canvas);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void addSetmodeEvent(StateEvent stateEvent) {
        if (stateEvent != null) {
            this.eventList.add(stateEvent);
        }
    }

    @Override
    public int getType() {
        return 0;
    }

    public void changeCursorTo(Mode mode) {
        Point hotSpot = new Point(0, 0);
        Toolkit kit = Toolkit.getDefaultToolkit();
        if (mode instanceof DefaultDrawingMode) {
            this.setCursor(new Cursor(0));
        } else if (mode instanceof RectangleMode) {
            this.setCursor(new Cursor(1));
        } else if (mode instanceof PolygonMode) {
            this.setCursor(new Cursor(1));
        } else if (mode instanceof AnchorMode) {
            Image img = new ImageIcon("./icons/anchor_cursor.png").getImage();
            String name = "anchor_cursor";
            this.setCursor(kit.createCustomCursor(img.getScaledInstance(60, 60, 1), hotSpot, name));
        } else if (mode instanceof BookmarkMode) {
            ImageIcon imageIcon = new ImageIcon("./icons/" + Preference.getInstance().getDefaultBookmarkPath());
            Image img = imageIcon.getImage();
            hotSpot = new Point(10, 30);
            String name = "bookmark_cursor";
            this.setCursor(kit.createCustomCursor(img.getScaledInstance(70, 70, 1), hotSpot, name));
        } else if (mode instanceof EraserMode) {
            Image img = new ImageIcon("./icons/eraser.png").getImage();
            String name = "eraser_cursor";
            this.setCursor(kit.createCustomCursor(img.getScaledInstance(70, 70, 1), new Point(5, 5), name));
        } else if (mode instanceof MemoPadMode) {
            Image img = new ImageIcon("./icons/memopad_cursor.png").getImage();
            String name = "memopad_cursor";
            this.setCursor(kit.createCustomCursor(img.getScaledInstance(48, 48, 1), hotSpot, name));
        } else if (mode instanceof MarkerMode) {
            Image img = new ImageIcon("./icons/marker_cursor.png").getImage();
            String name = "marker_cursor";
            hotSpot = new Point(0, 30);
            this.setCursor(kit.createCustomCursor(img.getScaledInstance(70, 70, 1), hotSpot, name));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    static {
        singleton.addSetmodeEvent(new DefaultStateEvent());
    }
}

