/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.DrawingModeAdapter;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.logical.region.PolygonRegion;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class PolygonMode
extends DrawingModeAdapter {
    private static Mode singleton = new PolygonMode();
    private Point2D start;
    private Point2D end;
    private boolean temporary = false;
    private List<Point2D> points;
    private Point2D tempStart;
    private Point2D tempEnd;
    private List<Point2D> tempPoints;
    private List<ExLine2D> lines = new ArrayList<ExLine2D>();
    private Component startcomponent;
    private boolean out = false;

    private PolygonMode() {
        this.points = new ArrayList<Point2D>();
        this.tempPoints = new ArrayList<Point2D>();
    }

    public static Mode getInstance() {
        return singleton;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean sw) {
        this.temporary = sw;
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.start == null) {
            this.startcomponent = null;
        }
        if (this.startcomponent != null && e.getComponent() != this.startcomponent) {
            this.setCursor(canvas);
            return;
        }
        super.mousePressed(e, canvas);
        if (e.getButton() != 1) {
            this.cancel();
            this.setCursor(canvas);
            return;
        }
        if (this.start == null) {
            this.startcomponent = e.getComponent();
            this.start = e.getPoint();
            this.tempStart = e.getOriginalPoint();
            this.points.add(this.start);
            this.tempPoints.add(this.tempStart);
            this.setCursor(canvas);
            return;
        }
        this.end = e.getPoint();
        this.tempEnd = e.getOriginalPoint();
        this.lines.add(new ExLine2D(this.start, this.end));
        this.points.add(this.end);
        this.tempPoints.add(this.tempEnd);
        this.start = this.end;
        this.tempStart = this.tempEnd;
        this.setCursor(canvas);
    }

    @Override
    public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.startcomponent != null && e.getComponent() != this.startcomponent) {
            return;
        }
        if (e.getButton() != 1) {
            this.setCursor(canvas);
            return;
        }
        if (e.getClickCount() == 2) {
            double minY;
            double minX;
            if (this.points.size() == 0) {
                this.setCursor(canvas);
                return;
            }
            double maxX = minX = this.points.get(0).getX();
            double maxY = minY = this.points.get(0).getY();
            for (int i = 0; i < this.points.size() - 1; ++i) {
                minX = Math.min(minX, this.points.get(i).getX());
                maxX = Math.max(maxX, this.points.get(i).getX());
                minY = Math.min(minY, this.points.get(i).getY());
                maxY = Math.max(maxY, this.points.get(i).getY());
            }
            if (maxX - minX > 10.0 && maxY - minY > 10.0) {
                PolygonRegion poly = new PolygonRegion(canvas.getSpread(), this.points);
                poly.setTemporary(this.isTemporary());
                canvas.getSpread().addRegion(poly);
            }
            this.lines = new ArrayList<ExLine2D>();
            this.points = new ArrayList<Point2D>();
            this.tempPoints = new ArrayList<Point2D>();
            this.start = null;
            this.end = null;
            this.tempStart = null;
            this.tempEnd = null;
            DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
            new ImageToolBarSetModeByMouseEvent().setMode(e, ImageToolBar.modeNone);
            this.setCursor(canvas);
            return;
        }
    }

    @Override
    public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
        this.out = e.getComponent() != this.startcomponent;
        this.setCursor(canvas);
        if (this.startcomponent != null && e.getComponent() != this.startcomponent) {
            return;
        }
        super.mouseMoved(e, canvas);
        this.end = e.getPoint();
        this.tempEnd = e.getOriginalPoint();
        this.setCursor(canvas);
    }

    @Override
    public void paint(Graphics g, SpreadCanvas canvas) {
        if (this.out) {
            return;
        }
        super.paint(g, canvas);
        if (this.start == null || this.end == null) {
            return;
        }
        double ratio = canvas.getImageLabel().getRatio();
        double gapX = canvas.getImageLabel().getGapWidth();
        double gapY = canvas.getImageLabel().getGapHeight();
        for (int i = 0; i < this.lines.size(); ++i) {
            ExLine2D line = this.lines.get(i);
            new LineView(line).enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
        }
        new LineView(new ExLine2D(this.start, this.end)).enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
        this.setCursor(canvas);
    }

    @Override
    public void cancel() {
        this.lines = new ArrayList<ExLine2D>();
        this.points = new ArrayList<Point2D>();
        this.tempPoints = new ArrayList<Point2D>();
        this.start = null;
        this.end = null;
        this.tempStart = null;
        this.tempEnd = null;
    }
}

